/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;

public class JsonQueryRequest
extends QueryRequest {
    private final Map<String, Object> jsonRequestMap = new HashMap<String, Object>();

    public JsonQueryRequest() {
        this(new ModifiableSolrParams());
    }

    public JsonQueryRequest(SolrParams params) {
        super(params, SolrRequest.METHOD.POST);
    }

    public JsonQueryRequest setQuery(String query) {
        if (query == null) {
            throw new IllegalArgumentException("'query' parameter must be non-null");
        }
        this.jsonRequestMap.put("query", query);
        return this;
    }

    public JsonQueryRequest setQuery(Map<String, Object> queryJson) {
        if (queryJson == null) {
            throw new IllegalArgumentException("'queryJson' parameter must be non-null");
        }
        this.jsonRequestMap.put("query", queryJson);
        return this;
    }

    public JsonQueryRequest setQuery(MapWriter queryWriter) {
        if (queryWriter == null) {
            throw new IllegalArgumentException("'queryWriter' parameter must be non-null");
        }
        this.jsonRequestMap.put("query", queryWriter);
        return this;
    }

    public JsonQueryRequest withFacet(String facetName, Map<String, Object> facetJson) {
        if (facetName == null) {
            throw new IllegalArgumentException("'facetName' parameter must be non-null");
        }
        if (facetJson == null) {
            throw new IllegalArgumentException("'facetMap' parameter must be non-null");
        }
        if (!this.jsonRequestMap.containsKey("facet")) {
            this.jsonRequestMap.put("facet", new HashMap());
        }
        Map facetMap = (Map)this.jsonRequestMap.get("facet");
        facetMap.put(facetName, facetJson);
        return this;
    }

    public JsonQueryRequest withFacet(String facetName, MapWriter facetWriter) {
        if (facetName == null) {
            throw new IllegalArgumentException("'facetName' parameter must be non-null");
        }
        if (facetWriter == null) {
            throw new IllegalArgumentException("'facetWriter' parameter must be non-null");
        }
        if (!this.jsonRequestMap.containsKey("facet")) {
            this.jsonRequestMap.put("facet", new HashMap());
        }
        Map facetMap = (Map)this.jsonRequestMap.get("facet");
        facetMap.put(facetName, facetWriter);
        return this;
    }

    public JsonQueryRequest withStatFacet(String facetName, String facetValue) {
        if (facetName == null) {
            throw new IllegalArgumentException("'facetName' parameter must be non-null");
        }
        if (facetValue == null) {
            throw new IllegalArgumentException("'facetValue' parameter must be non-null");
        }
        if (!this.jsonRequestMap.containsKey("facet")) {
            this.jsonRequestMap.put("facet", new HashMap());
        }
        Map facetMap = (Map)this.jsonRequestMap.get("facet");
        facetMap.put(facetName, facetValue);
        return this;
    }

    public JsonQueryRequest setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' parameter must be non-negative");
        }
        this.jsonRequestMap.put("offset", offset);
        return this;
    }

    public JsonQueryRequest setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' parameter must be non-negative");
        }
        this.jsonRequestMap.put("limit", limit);
        return this;
    }

    public JsonQueryRequest setSort(String sort) {
        if (sort == null) {
            throw new IllegalArgumentException("'sort' parameter must be non-null");
        }
        this.jsonRequestMap.put("sort", sort);
        return this;
    }

    public JsonQueryRequest withFilter(String filterQuery) {
        if (filterQuery == null) {
            throw new IllegalArgumentException("'filterQuery' must be non-null");
        }
        ((List)this.jsonRequestMap.computeIfAbsent("filter", s -> new ArrayList())).add(filterQuery);
        return this;
    }

    public JsonQueryRequest withFilter(Map<String, Object> filterQuery) {
        if (filterQuery == null) {
            throw new IllegalArgumentException("'filterQuery' parameter must be non-null");
        }
        ((List)this.jsonRequestMap.computeIfAbsent("filter", s -> new ArrayList())).add(filterQuery);
        return this;
    }

    public JsonQueryRequest returnFields(String ... fieldNames) {
        this.jsonRequestMap.putIfAbsent("fields", new ArrayList());
        List fields = (List)this.jsonRequestMap.get("fields");
        for (String fieldName : fieldNames) {
            fields.add(fieldName);
        }
        return this;
    }

    public JsonQueryRequest returnFields(Iterable<String> fieldNames) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("'fieldNames' parameter must be non-null");
        }
        this.jsonRequestMap.putIfAbsent("fields", new ArrayList());
        List fields = (List)this.jsonRequestMap.get("fields");
        for (String fieldName : fieldNames) {
            fields.add(fieldName);
        }
        return this;
    }

    public JsonQueryRequest withParam(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("'name' parameter must be non-null");
        }
        if (value == null) {
            throw new IllegalArgumentException("'value' parameter must be non-null");
        }
        ((Map)this.jsonRequestMap.computeIfAbsent("params", s -> new HashMap())).put(name, value);
        return this;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                Utils.writeJson(JsonQueryRequest.this.jsonRequestMap, os, true);
            }

            @Override
            public String getContentType() {
                return "application/json; charset=UTF-8";
            }
        };
    }

    @Override
    public void setMethod(SolrRequest.METHOD m) {
        if (SolrRequest.METHOD.POST != m) {
            String message = this.getClass().getName() + " only supports POST for sending JSON queries.";
            throw new UnsupportedOperationException(message);
        }
    }
}

