/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="EditorConfigPreviewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class EditorConfigPreviewManager
implements PersistentStateComponent<Element> {
    private final Map<String, String> myPreviewMap = new HashMap<String, String>();
    public static final String PREVIEW_RECORD_TAG = "editorConfig";
    public static final String EDITORCONFIG_FILE_ATTR = "file";
    public static final String PREVIEW_FILE_ATTR = "previewFile";

    @NotNull
    public Element getState() {
        Element state = new Element("previewData");
        for (String key : this.myPreviewMap.keySet()) {
            String value = this.myPreviewMap.get(key);
            if (value == null) continue;
            Element previewRec = new Element(PREVIEW_RECORD_TAG);
            previewRec.setAttribute(EDITORCONFIG_FILE_ATTR, key);
            previewRec.setAttribute(PREVIEW_FILE_ATTR, value);
            state.addContent(previewRec);
        }
        Element element = state;
        if (element == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(0);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(1);
        }
        for (Element previewRec : state.getChildren(PREVIEW_RECORD_TAG)) {
            String key = previewRec.getAttributeValue(EDITORCONFIG_FILE_ATTR);
            String value = previewRec.getAttributeValue(PREVIEW_FILE_ATTR);
            if (key == null || value == null) continue;
            this.myPreviewMap.put(key, value);
        }
    }

    public static EditorConfigPreviewManager getInstance(@NotNull Project project) {
        if (project == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(2);
        }
        return (EditorConfigPreviewManager)project.getService(EditorConfigPreviewManager.class);
    }

    public void associateWithPreviewFile(@NotNull VirtualFile editorConfigFile, @Nullable VirtualFile previewFile) {
        if (editorConfigFile == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(3);
        }
        if (previewFile != null) {
            this.myPreviewMap.put(editorConfigFile.getPath(), previewFile.getPath());
        } else {
            this.myPreviewMap.remove(editorConfigFile.getPath());
        }
    }

    @Nullable
    public VirtualFile getAssociatedPreviewFile(@NotNull VirtualFile editorConfigFile) {
        String editorConfigFilePath;
        String previewPathStr;
        if (editorConfigFile == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(4);
        }
        if ((previewPathStr = this.myPreviewMap.get(editorConfigFilePath = editorConfigFile.getPath())) != null) {
            Path previewPath = Paths.get(previewPathStr, new String[0]);
            VirtualFile actualFile = VfsUtil.findFile((Path)previewPath, (boolean)true);
            if (actualFile == null) {
                this.myPreviewMap.remove(editorConfigFilePath);
            }
            return actualFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "associateWithPreviewFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedPreviewFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

