/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;

public final class LocalTerminalStartCommandBuilder {
    public static final String INTERACTIVE_CLI_OPTION = "-i";

    @NotNull
    public static List<String> convertShellPathToCommand(@NotNull String shellPath2) {
        if (shellPath2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(0);
        }
        return LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2, (List<String> shellCommand) -> LocalEelDescriptor.INSTANCE);
    }

    @NotNull
    public static List<String> convertShellPathToCommand(@NotNull String shellPath2, @NotNull String workingDirectory) {
        if (shellPath2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(2);
        }
        return LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2, (List<String> shellCommand) -> TerminalStartupKt.findEelDescriptor(workingDirectory, shellCommand));
    }

    @NotNull
    private static List<String> convertShellPathToCommand(@NotNull String shellPath2, @NotNull Function<List<String>, EelDescriptor> eelDescriptorProvider) {
        if (shellPath2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(3);
        }
        if (eelDescriptorProvider == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<String> shellCommand = LocalTerminalStartCommandBuilder.isAbsoluteFilePathAndExists(shellPath2) ? List.of(shellPath2) : ParametersListUtil.parse((String)shellPath2, (boolean)false, (OS.CURRENT != OS.Windows ? 1 : 0) != 0);
        EelDescriptor eelDescriptor = eelDescriptorProvider.apply(shellCommand);
        String shellExe = (String)ContainerUtil.getFirstItem((List)shellCommand);
        if (shellExe == null) {
            ArrayList<String> arrayList = shellCommand;
            if (arrayList == null) {
                LocalTerminalStartCommandBuilder.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        String shellName = PathUtil.getFileName((String)shellExe);
        if (!LocalTerminalStartCommandBuilder.containsLoginOrInteractiveOption((List<String>)shellCommand)) {
            shellCommand = new ArrayList<String>(shellCommand);
            if (LocalTerminalStartCommandBuilder.isLoginOptionAvailable(shellName) && LocalTerminalStartCommandBuilder.isLoginShellNeeded(eelDescriptor)) {
                shellCommand.add("--login");
            }
            if (LocalTerminalStartCommandBuilder.isInteractiveOptionAvailable(shellName)) {
                shellCommand.add(INTERACTIVE_CLI_OPTION);
            }
        }
        List<String> list = List.copyOf(shellCommand);
        if (list == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isLoginShellNeeded(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(7);
        }
        return eelDescriptor == LocalEelDescriptor.INSTANCE && OS.CURRENT == OS.macOS || eelDescriptor != LocalEelDescriptor.INSTANCE && EelPlatformKt.isPosix((EelOsFamily)eelDescriptor.getOsFamily());
    }

    private static boolean isAbsoluteFilePathAndExists(@NotNull String path) {
        Path file;
        if (path == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(8);
        }
        return (file = NioFiles.toPath((String)path)) != null && file.isAbsolute() && Files.isRegularFile(file, new LinkOption[0]);
    }

    private static boolean containsLoginOrInteractiveOption(List<String> command2) {
        return LocalTerminalStartCommandBuilder.isLogin(command2) || command2.contains(INTERACTIVE_CLI_OPTION);
    }

    private static boolean isLogin(@NotNull List<String> command2) {
        if (command2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(command2, LocalTerminalDirectRunner.LOGIN_CLI_OPTIONS::contains);
    }

    private static boolean isLoginOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(10);
        }
        return ShellNameUtil.isBashZshFish(shellName);
    }

    private static boolean isInteractiveOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(11);
        }
        return ShellNameUtil.isBashZshFish(shellName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptorProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalTerminalStartCommandBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalTerminalStartCommandBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertShellPathToCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertShellPathToCommand";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLoginShellNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteFilePathAndExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLogin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLoginOptionAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveOptionAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

