/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0004\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n*\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "asSubmodule", "Lgit4idea/repo/GitSubmodule;", "Lgit4idea/repo/GitRepository;", "isParentRepositoryFor", "", "submodule", "isSubmodule", "getDirectSubmodules", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSubmodule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSubmodule.kt\ngit4idea/repo/GitSubmoduleKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,42:1\n1#2:43\n1#2:54\n1617#3,9:44\n1869#3:53\n1870#3:55\n1626#3:56\n1761#3,3:57\n13#4:60\n*S KotlinDebug\n*F\n+ 1 GitSubmodule.kt\ngit4idea/repo/GitSubmoduleKt\n*L\n29#1:54\n29#1:44,9\n29#1:53\n29#1:55\n29#1:56\n23#1:57,3\n8#1:60\n*E\n"})
public final class GitSubmoduleKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final GitSubmodule asSubmodule(@NotNull GitRepository $this$asSubmodule) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$asSubmodule, (String)"<this>");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance($this$asSubmodule.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
            GitRepositoryManager repositoryManager = gitRepositoryManager;
            List<GitRepository> list = repositoryManager.getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                GitRepository it = (GitRepository)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!GitSubmoduleKt.isParentRepositoryFor(it, $this$asSubmodule)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        GitRepository parent = v2;
        return parent != null ? new GitSubmodule($this$asSubmodule, parent) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isParentRepositoryFor(GitRepository $this$isParentRepositoryFor, GitRepository submodule) {
        if (!VfsUtil.isAncestor((VirtualFile)$this$isParentRepositoryFor.getRoot(), (VirtualFile)submodule.getRoot(), (boolean)true)) return false;
        Collection<GitSubmoduleInfo> collection = $this$isParentRepositoryFor.getSubmodules();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSubmodules(...)");
        if (collection.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        if ((Boolean)ActionsKt.runReadAction(() -> GitSubmoduleKt.isParentRepositoryFor$lambda$0($this$isParentRepositoryFor, submodule)) == false) return false;
        return true;
    }

    public static final boolean isSubmodule(@NotNull GitRepository $this$isSubmodule) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubmodule, (String)"<this>");
        return GitSubmoduleKt.asSubmodule($this$isSubmodule) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<GitRepository> getDirectSubmodules(@NotNull GitRepository $this$getDirectSubmodules) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getDirectSubmodules, (String)"<this>");
        Collection<GitSubmoduleInfo> collection = $this$getDirectSubmodules.getSubmodules();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSubmodules(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitRepository gitRepository;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitSubmoduleInfo module = (GitSubmoduleInfo)element$iv$iv;
            boolean bl2 = false;
            VirtualFile submoduleDir = $this$getDirectSubmodules.getRoot().findFileByRelativePath(module.getPath());
            if (submoduleDir == null) {
                LOG.debug("submodule dir not found at declared path [" + module.getPath() + "] of root [" + $this$getDirectSubmodules.getRoot() + "]");
                gitRepository = null;
            } else {
                GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance($this$getDirectSubmodules.getProject()).getRepositoryForRoot(submoduleDir);
                if (repository2 == null) {
                    LOG.warn("Submodule not registered as a repository: " + submoduleDir);
                }
                gitRepository = repository2;
            }
            if (gitRepository == null) continue;
            GitRepository it$iv$iv = gitRepository;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isParentRepositoryFor$lambda$0(GitRepository $this_isParentRepositoryFor, GitRepository $submodule) {
        boolean bl;
        block3: {
            Collection<GitSubmoduleInfo> collection = $this_isParentRepositoryFor.getSubmodules();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSubmodules(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitSubmoduleInfo module = (GitSubmoduleInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)$this_isParentRepositoryFor.getRoot().findFileByRelativePath(module.getPath()), (Object)$submodule.getRoot())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitSubmodule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

