/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPullDialog
extends DialogWrapper {
    private final Project project;
    private HgRepositorySelectorComponent hgRepositorySelector;
    private JPanel mainPanel;
    private EditorComboBox myRepositoryURL;
    private String myCurrentRepositoryUrl;

    public HgPullDialog(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            HgPullDialog.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            HgPullDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.project = project;
        this.$$$setupUI$$$();
        this.hgRepositorySelector.setTitle(HgBundle.message("action.hg4idea.pull.select.repo", new Object[0]));
        this.hgRepositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgPullDialog.this.onChangeRepository();
            }
        });
        this.setTitle(HgBundle.message("action.hg4idea.pull", new Object[0]));
        this.setOKButtonText(HgBundle.message("action.hg4idea.pull", new Object[0]));
        this.init();
        this.setRoots(repositories, selectedRepo);
    }

    public void createUIComponents() {
        this.myRepositoryURL = new EditorComboBox("");
        this.myRepositoryURL.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                HgPullDialog.this.onChangePullSource();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/ui/HgPullDialog$2", "documentChanged"));
            }
        });
    }

    private void addPathsFromHgrc(@NotNull VirtualFile repo) {
        if (repo == null) {
            HgPullDialog.$$$reportNull$$$0(2);
        }
        Collection<String> paths = HgUtil.getRepositoryPaths(this.project, repo);
        for (String path : paths) {
            this.myRepositoryURL.prependItem(path);
        }
    }

    @NotNull
    public HgRepository getRepository() {
        HgRepository hgRepository = this.hgRepositorySelector.getRepository();
        if (hgRepository == null) {
            HgPullDialog.$$$reportNull$$$0(3);
        }
        return hgRepository;
    }

    public String getSource() {
        return this.myCurrentRepositoryUrl;
    }

    private void setRoots(@NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (repositories == null) {
            HgPullDialog.$$$reportNull$$$0(4);
        }
        this.hgRepositorySelector.setRoots(repositories);
        this.hgRepositorySelector.setSelectedRoot(selectedRepo);
        this.onChangeRepository();
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getHelpId() {
        return "reference.mercurial.pull.dialog";
    }

    private void onChangeRepository() {
        VirtualFile repo = this.hgRepositorySelector.getRepository().getRoot();
        String defaultPath = HgUtil.getRepositoryDefaultPath(this.project, repo);
        if (!StringUtil.isEmptyOrSpaces((String)defaultPath)) {
            this.addPathsFromHgrc(repo);
            this.myRepositoryURL.setText(HgUtil.removePasswordIfNeeded(defaultPath));
            this.myCurrentRepositoryUrl = defaultPath;
            this.onChangePullSource();
        }
    }

    private void onChangePullSource() {
        this.myCurrentRepositoryUrl = this.myRepositoryURL.getText();
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.myRepositoryURL.getText()));
    }

    protected String getDimensionServiceKey() {
        return HgPullDialog.class.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/ui/HgPullDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/ui/HgPullDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPathsFromHgrc";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.hgRepositorySelector = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/HgBundle", HgPullDialog.class).getString("action.hg4idea.pull.from"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        EditorComboBox editorComboBox = this.myRepositoryURL;
        editorComboBox.setEditable(true);
        jPanel2.add((Component)editorComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

