/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StartOnlyMatcher;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.XmlSmartCompletionProvider;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.emmet.completion.EmmetAbbreviationCompletionProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> WORD_COMPLETION_COMPATIBLE = Key.create((String)"WORD_COMPLETION_COMPATIBLE");
    public static final EntityRefInsertHandler ENTITY_INSERT_HANDLER = new EntityRefInsertHandler();
    @NonNls
    public static final String TAG_NAME_COMPLETION_FEATURE = "tag.name.completion";
    private static final InsertHandler<LookupElementDecorator<LookupElement>> QUOTE_EATER = new InsertHandlerDecorator<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
            char completionChar;
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((completionChar = context.getCompletionChar()) == '\'' || completionChar == '\"') {
                char c;
                context.setAddCompletionChar(false);
                item.getDelegate().handleInsert(context);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int tailOffset = editor.getCaretModel().getOffset();
                if (document.getTextLength() > tailOffset && ((c = document.getCharsSequence().charAt(tailOffset)) == completionChar || completionChar == '\'')) {
                    editor.getCaretModel().moveToOffset(tailOffset + 1);
                }
            } else {
                item.getDelegate().handleInsert(context);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public XmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), new EmmetAbbreviationCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                IElementType type;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((type = (position = parameters.getPosition()).getNode().getElementType()) != XmlTokenType.XML_DATA_CHARACTERS && type != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return;
                }
                if (position.getPrevSibling() != null && position.getPrevSibling().textMatches((CharSequence)"&") || position.textContains('&')) {
                    PrefixMatcher matcher = result.getPrefixMatcher();
                    String prefix = matcher.getPrefix();
                    if (prefix.startsWith("&")) {
                        prefix = prefix.substring(1);
                    } else if (prefix.contains("&")) {
                        prefix = prefix.substring(prefix.indexOf("&") + 1);
                    }
                    matcher = matcher.cloneWithPrefix(prefix);
                    if (parameters.getInvocationCount() == 0) {
                        matcher = new StartOnlyMatcher(matcher);
                    }
                    XmlCompletionContributor.addEntityRefCompletions(position, result.withPrefixMatcher(matcher));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!(position = parameters.getPosition()).getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue == null) {
                    return;
                }
                HashSet usedWords = new HashSet();
                Ref addWordVariants = Ref.create((Object)true);
                result.runRemainingContributors(parameters, r -> {
                    if (r.getLookupElement().getUserData(WORD_COMPLETION_COMPATIBLE) == null) {
                        addWordVariants.set((Object)false);
                    }
                    usedWords.add(r.getLookupElement().getLookupString());
                    result.passResult(r.withLookupElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)r.getLookupElement(), QUOTE_EATER)));
                });
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    addWordVariants.set((Object)(attributeValue.getReferences().length == 0 ? 1 : 0));
                }
                if (((Boolean)addWordVariants.get()).booleanValue() && parameters.getInvocationCount() > 0) {
                    WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result, (CompletionParameters)parameters, usedWords);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withElementType(XmlTokenType.XML_DATA_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                XmlTag simpleContent;
                XmlTag tag;
                if (parameters == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlTag.class, (boolean)false)) != null && !XmlCompletionContributor.hasEnumerationReference(parameters, result) && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)tag)) != null) {
                    XmlUtil.processEnumerationValues((XmlTag)simpleContent, element -> {
                        String value = element.getAttributeValue("value");
                        assert (value != null);
                        result.addElement((LookupElement)LookupElementBuilder.create((String)value));
                        return true;
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$4";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static boolean hasEnumerationReference(CompletionParameters parameters, CompletionResultSet result) {
        Ref hasRef = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result, (reference, resultSet) -> {
            if (reference instanceof XmlEnumeratedValueReference) {
                hasRef.set((Object)true);
            }
        });
        return (Boolean)hasRef.get();
    }

    public static boolean isXmlNameCompletion(CompletionParameters parameters) {
        ASTNode node = parameters.getPosition().getNode();
        return node != null && node.getElementType() == XmlTokenType.XML_NAME;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            XmlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            XmlCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
        if (result.isStopped()) {
            return;
        }
        PsiElement element = parameters.getPosition();
        if (parameters.isExtendedCompletion()) {
            XmlCompletionContributor.completeTagName(parameters, result);
        } else if (parameters.getCompletionType() == CompletionType.SMART) {
            new XmlSmartCompletionProvider().complete(parameters, result, element);
        }
    }

    static void completeTagName(CompletionParameters parameters, CompletionResultSet result) {
        XmlTag tag;
        block8: {
            block7: {
                PsiElement element = parameters.getPosition();
                if (!XmlCompletionContributor.isXmlNameCompletion(parameters)) {
                    return;
                }
                PsiElement parent = element.getParent();
                if (!(parent instanceof XmlTag)) break block7;
                tag = (XmlTag)parent;
                if (parameters.getOriginalFile() instanceof XmlFile) break block8;
            }
            return;
        }
        result.stopHere();
        String namespace = tag.getNamespace();
        String prefix = result.getPrefixMatcher().getPrefix();
        int pos = prefix.indexOf(58);
        PsiReference reference = tag.getReference();
        String namespacePrefix = tag.getNamespacePrefix();
        if (reference != null && !namespace.isEmpty() && !namespacePrefix.isEmpty()) {
            result.runRemainingContributors(parameters, true);
        } else {
            CompletionResultSet newResult = result.withPrefixMatcher(pos >= 0 ? prefix.substring(pos + 1) : prefix);
            XmlFile file = (XmlFile)parameters.getOriginalFile();
            List names = XmlExtension.getExtension((PsiFile)file).getAvailableTagNames(file, tag);
            for (XmlExtension.TagInfo info : names) {
                LookupElement item = XmlCompletionContributor.createLookupElement(info, info.namespace, namespacePrefix.isEmpty() ? null : namespacePrefix);
                newResult.addElement(item);
            }
        }
    }

    public static LookupElement createLookupElement(XmlExtension.TagInfo tagInfo, String tailText, @Nullable String namespacePrefix) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)tagInfo, (String)tagInfo.name).withInsertHandler((InsertHandler)new ExtendedTagInsertHandler(tagInfo.name, tagInfo.namespace, namespacePrefix));
        if (!StringUtil.isEmpty((String)tailText)) {
            builder = builder.withTypeText(tailText, true);
        }
        return builder;
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            XmlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (XmlCompletionContributor.isXmlNameCompletion(parameters) && parameters.getCompletionType() == CompletionType.BASIC && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(TAG_NAME_COMPLETION_FEATURE, parameters.getPosition().getProject())) {
            String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
            return XmlBundle.message("tag.name.completion.hint", shortcut);
        }
        return super.advertise(parameters);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement at;
        if (context == null) {
            XmlCompletionContributor.$$$reportNull$$$0(3);
        }
        int offset = context.getStartOffset();
        PsiFile file = context.getFile();
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, XmlAttributeValue.class, (boolean)true);
        if (attributeValue != null && offset == attributeValue.getTextRange().getStartOffset()) {
            context.setDummyIdentifier("");
        }
        if ((at = file.findElementAt(offset)) != null && at.getNode().getElementType() == XmlTokenType.XML_NAME && at.getParent() instanceof XmlAttribute) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, at.getTextRange().getEndOffset());
        }
        if (at != null && at.getParent() instanceof XmlAttributeValue) {
            int end = at.getParent().getTextRange().getEndOffset();
            Document document = context.getEditor().getDocument();
            int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
            if (lineEnd < end) {
                context.setReplacementOffset(lineEnd);
            }
        }
    }

    private static void addEntityRefCompletions(PsiElement context, final CompletionResultSet resultSet) {
        XmlProlog element;
        XmlFile containingFile = (XmlFile)ObjectUtils.tryCast((Object)context.getContainingFile(), XmlFile.class);
        if (containingFile == null) {
            return;
        }
        List descriptorFiles = XmlExtension.getExtension((PsiFile)containingFile).getCharEntitiesDTDs(containingFile);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (tag != null && descriptorFiles.isEmpty()) {
            descriptorFiles = ContainerUtil.packNullables((Object[])new XmlFile[]{XmlUtil.findDescriptorFile((XmlTag)tag, (XmlFile)containingFile)});
        }
        final boolean acceptSystemEntities = containingFile.getFileType() == XmlFileType.INSTANCE;
        PsiElementProcessor<PsiElement> processor = new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                LookupElementBuilder _item;
                XmlEntityDecl xmlEntityDecl;
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlEntityDecl && ((xmlEntityDecl = (XmlEntityDecl)element).isInternalReference() || acceptSystemEntities) && (_item = XmlCompletionContributor.buildEntityLookupItem(xmlEntityDecl)) != null) {
                    resultSet.addElement((LookupElement)_item);
                    resultSet.stopHere();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/XmlCompletionContributor$5", "execute"));
            }
        };
        for (XmlFile descriptorFile : descriptorFiles) {
            XmlUtil.processXmlElements((XmlElement)descriptorFile, (PsiElementProcessor)processor, (boolean)true);
        }
        XmlDocument document = containingFile.getDocument();
        if (acceptSystemEntities && document != null && (element = document.getProlog()) != null) {
            XmlUtil.processXmlElements((XmlElement)element, (PsiElementProcessor)processor, (boolean)true);
        }
    }

    @Nullable
    private static LookupElementBuilder buildEntityLookupItem(@NotNull XmlEntityDecl decl) {
        String valueText;
        int i;
        ASTNode[] nodes;
        String name;
        if (decl == null) {
            XmlCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((name = decl.getName()) == null) {
            return null;
        }
        LookupElementBuilder result = LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)ENTITY_INSERT_HANDLER);
        XmlAttributeValue value = decl.getValueElement();
        ASTNode node = value.getNode();
        if (node != null && (nodes = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CHAR_ENTITY_REF}))).length == 1 && (i = (valueText = nodes[0].getText()).indexOf(35)) > 0) {
            String s = valueText.substring(i + 1);
            s = StringUtil.trimEnd((String)s, (String)";");
            try {
                char unicodeChar = (char)Integer.valueOf(s).intValue();
                return result.withTypeText(String.valueOf(unicodeChar)).withLookupString(String.valueOf(unicodeChar));
            }
            catch (NumberFormatException e) {
                return result;
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advertise";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildEntityLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EntityRefInsertHandler
    extends BasicInsertHandler<LookupElement> {
        private EntityRefInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                EntityRefInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                EntityRefInsertHandler.$$$reportNull$$$0(1);
            }
            super.handleInsert(context, item);
            context.setAddCompletionChar(false);
            Editor editor = context.getEditor();
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (!CharArrayUtil.regionMatches((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (CharSequence)";")) {
                editor.getDocument().insertString(caretOffset, (CharSequence)";");
            }
            caretModel.moveToOffset(caretOffset + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/XmlCompletionContributor$EntityRefInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

