/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLParserDefinition;
import org.jetbrains.yaml.YAMLTokenTypes;

public interface YAMLElementTypes {
    public static final YAMLElementType DOCUMENT = new YAMLElementType("Document ---");
    public static final YAMLElementType KEY_VALUE_PAIR = new YAMLElementType("Key value pair");
    public static final YAMLElementType HASH = new YAMLElementType("Hash");
    public static final YAMLElementType ARRAY = new YAMLElementType("Array");
    public static final YAMLElementType SEQUENCE_ITEM = new YAMLElementType("Sequence item");
    public static final YAMLElementType COMPOUND_VALUE = new YAMLElementType("Compound value");
    public static final YAMLElementType MAPPING = new YAMLElementType("Mapping");
    public static final YAMLElementType SEQUENCE = new YAMLElementType("Sequence");
    public static final YAMLElementType SCALAR_LIST_VALUE = new YAMLElementType("Scalar list value");
    public static final YAMLElementType SCALAR_TEXT_VALUE = new YAMLElementType("Scalar text value");
    public static final YAMLElementType SCALAR_PLAIN_VALUE = new YAMLElementType("Scalar plain style");
    public static final YAMLElementType SCALAR_QUOTED_STRING = new YAMLElementType("Scalar quoted string");
    public static final YAMLElementType ANCHOR_NODE = new YAMLElementType("Anchor node");
    public static final YAMLElementType ALIAS_NODE = new YAMLElementType("Alias node");
    public static final TokenSet BLOCK_SCALAR_ITEMS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.SCALAR_LIST, YAMLTokenTypes.SCALAR_TEXT});
    public static final TokenSet TEXT_SCALAR_ITEMS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.SCALAR_STRING, YAMLTokenTypes.SCALAR_DSTRING, YAMLTokenTypes.TEXT});
    public static final TokenSet SCALAR_ITEMS = TokenSet.orSet((TokenSet[])new TokenSet[]{BLOCK_SCALAR_ITEMS, TEXT_SCALAR_ITEMS});
    public static final TokenSet SCALAR_VALUES = TokenSet.orSet((TokenSet[])new TokenSet[]{SCALAR_ITEMS, TokenSet.create((IElementType[])new IElementType[]{SCALAR_LIST_VALUE})});
    public static final TokenSet EOL_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.EOL, YAMLTokenTypes.SCALAR_EOL});
    public static final TokenSet SPACE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{EOL_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.WHITESPACE, TokenType.WHITE_SPACE, YAMLTokenTypes.INDENT})});
    public static final TokenSet BLANK_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{SPACE_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COMMENT})});
    public static final TokenSet CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{SCALAR_LIST_VALUE, SCALAR_TEXT_VALUE, DOCUMENT, SEQUENCE, MAPPING, SCALAR_QUOTED_STRING, SCALAR_PLAIN_VALUE});
    public static final TokenSet BRACKETS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.LBRACE, YAMLTokenTypes.RBRACE, YAMLTokenTypes.LBRACKET, YAMLTokenTypes.RBRACKET});
    public static final TokenSet DOCUMENT_BRACKETS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.DOCUMENT_MARKER, YAMLTokenTypes.DOCUMENT_END});
    public static final TokenSet TOP_LEVEL = TokenSet.create((IElementType[])new IElementType[]{YAMLParserDefinition.FILE, DOCUMENT});
    public static final TokenSet INCOMPLETE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{MAPPING, SEQUENCE, COMPOUND_VALUE, SCALAR_LIST_VALUE, SCALAR_TEXT_VALUE});
    public static final TokenSet YAML_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COMMENT});
    public static final TokenSet WHITESPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.WHITESPACE});
}

