/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.NodeApiVersions;

public class ApiVersions {
    private final Map<String, NodeApiVersions> nodeApiVersions = new HashMap<String, NodeApiVersions>();
    private long maxFinalizedFeaturesEpoch = -1L;
    private Map<String, Short> finalizedFeatures;

    public synchronized void update(String nodeId, NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions.put(nodeId, nodeApiVersions);
        if (this.maxFinalizedFeaturesEpoch < nodeApiVersions.finalizedFeaturesEpoch()) {
            this.maxFinalizedFeaturesEpoch = nodeApiVersions.finalizedFeaturesEpoch();
            this.finalizedFeatures = nodeApiVersions.finalizedFeatures();
        }
    }

    public synchronized void remove(String nodeId) {
        this.nodeApiVersions.remove(nodeId);
    }

    public synchronized NodeApiVersions get(String nodeId) {
        return this.nodeApiVersions.get(nodeId);
    }

    public synchronized long getMaxFinalizedFeaturesEpoch() {
        return this.maxFinalizedFeaturesEpoch;
    }

    public synchronized FinalizedFeaturesInfo getFinalizedFeaturesInfo() {
        return new FinalizedFeaturesInfo(this.maxFinalizedFeaturesEpoch, this.finalizedFeatures);
    }

    public static class FinalizedFeaturesInfo {
        public final long finalizedFeaturesEpoch;
        public final Map<String, Short> finalizedFeatures;

        FinalizedFeaturesInfo(long finalizedFeaturesEpoch, Map<String, Short> finalizedFeatures) {
            this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
            this.finalizedFeatures = finalizedFeatures;
        }
    }
}

