/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.os;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.performanceanalyzer.commons.config.ConfigStatus;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;

public class OSGlobals {
    private static long scClkTck;
    private static String pid;
    private static final String CLK_TCK_SYS_PROPERTY_NAME = "clk.tck";
    private static final Logger LOGGER;
    private static final long REFRESH_INTERVAL_MS;
    private static List<String> tids;
    private static long lastUpdated;

    public static String getPid() {
        return pid;
    }

    public static long getScClkTck() {
        return scClkTck;
    }

    private static void getScClkTckFromConfig() throws Exception {
        try {
            scClkTck = Long.parseUnsignedLong(System.getProperty(CLK_TCK_SYS_PROPERTY_NAME));
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("Error in reading/parsing clk.tck value: {}", (Object)e.toString()), (Throwable)e);
            ConfigStatus.INSTANCE.setConfigurationInvalid();
        }
    }

    private static void enumTids() {
        tids.clear();
        tids.add(pid);
        File self = new File("/proc/self/task");
        File[] filesList = self.listFiles();
        if (filesList != null) {
            for (File f : filesList) {
                if (!f.isDirectory()) continue;
                String tid = f.getName();
                tids.add(tid);
            }
        }
    }

    static synchronized List<String> getTids() {
        long curtime = System.currentTimeMillis();
        if (curtime - lastUpdated > REFRESH_INTERVAL_MS) {
            OSGlobals.enumTids();
            lastUpdated = curtime;
        }
        return new ArrayList<String>(tids);
    }

    static {
        LOGGER = LogManager.getLogger(OSGlobals.class);
        REFRESH_INTERVAL_MS = MetricsConfiguration.CONFIG_MAP.get(OSGlobals.class).samplingInterval;
        tids = new ArrayList<String>();
        lastUpdated = -1L;
        try {
            pid = new File("/proc/self").getCanonicalFile().getName();
            OSGlobals.getScClkTckFromConfig();
            OSGlobals.enumTids();
            lastUpdated = System.currentTimeMillis();
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("Error in static initialization of OSGlobals with exception: {}", (Object)e.toString()), (Throwable)e);
        }
    }
}

