/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.SemanticDenseEmbeddingConfig;
import org.opensearch.client.opensearch._types.mapping.SemanticSparseEncodingConfig;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SemanticProperty
implements PropertyVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, SemanticProperty> {
    @Nullable
    private final JsonData chunking;
    @Nullable
    private final SemanticDenseEmbeddingConfig denseEmbeddingConfig;
    @Nonnull
    private final String modelId;
    @Nullable
    private final String rawFieldType;
    @Nullable
    private final String searchModelId;
    @Nullable
    private final String semanticFieldSearchAnalyzer;
    @Nullable
    private final String semanticInfoFieldName;
    @Nullable
    private final Boolean skipExistingEmbedding;
    @Nullable
    private final SemanticSparseEncodingConfig sparseEncodingConfig;
    public static final JsonpDeserializer<SemanticProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticProperty::setupSemanticPropertyDeserializer);

    private SemanticProperty(Builder builder) {
        this.chunking = builder.chunking;
        this.denseEmbeddingConfig = builder.denseEmbeddingConfig;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.rawFieldType = builder.rawFieldType;
        this.searchModelId = builder.searchModelId;
        this.semanticFieldSearchAnalyzer = builder.semanticFieldSearchAnalyzer;
        this.semanticInfoFieldName = builder.semanticInfoFieldName;
        this.skipExistingEmbedding = builder.skipExistingEmbedding;
        this.sparseEncodingConfig = builder.sparseEncodingConfig;
    }

    public static SemanticProperty of(Function<Builder, ObjectBuilder<SemanticProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Semantic;
    }

    @Nullable
    public final JsonData chunking() {
        return this.chunking;
    }

    @Nullable
    public final SemanticDenseEmbeddingConfig denseEmbeddingConfig() {
        return this.denseEmbeddingConfig;
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String rawFieldType() {
        return this.rawFieldType;
    }

    @Nullable
    public final String searchModelId() {
        return this.searchModelId;
    }

    @Nullable
    public final String semanticFieldSearchAnalyzer() {
        return this.semanticFieldSearchAnalyzer;
    }

    @Nullable
    public final String semanticInfoFieldName() {
        return this.semanticInfoFieldName;
    }

    @Nullable
    public final Boolean skipExistingEmbedding() {
        return this.skipExistingEmbedding;
    }

    @Nullable
    public final SemanticSparseEncodingConfig sparseEncodingConfig() {
        return this.sparseEncodingConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "semantic");
        if (this.chunking != null) {
            generator.writeKey("chunking");
            this.chunking.serialize(generator, mapper);
        }
        if (this.denseEmbeddingConfig != null) {
            generator.writeKey("dense_embedding_config");
            this.denseEmbeddingConfig.serialize(generator, mapper);
        }
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.rawFieldType != null) {
            generator.writeKey("raw_field_type");
            generator.write(this.rawFieldType);
        }
        if (this.searchModelId != null) {
            generator.writeKey("search_model_id");
            generator.write(this.searchModelId);
        }
        if (this.semanticFieldSearchAnalyzer != null) {
            generator.writeKey("semantic_field_search_analyzer");
            generator.write(this.semanticFieldSearchAnalyzer);
        }
        if (this.semanticInfoFieldName != null) {
            generator.writeKey("semantic_info_field_name");
            generator.write(this.semanticInfoFieldName);
        }
        if (this.skipExistingEmbedding != null) {
            generator.writeKey("skip_existing_embedding");
            generator.write(this.skipExistingEmbedding.booleanValue());
        }
        if (this.sparseEncodingConfig != null) {
            generator.writeKey("sparse_encoding_config");
            this.sparseEncodingConfig.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSemanticPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunking, JsonData._DESERIALIZER, "chunking");
        op.add(Builder::denseEmbeddingConfig, SemanticDenseEmbeddingConfig._DESERIALIZER, "dense_embedding_config");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::rawFieldType, JsonpDeserializer.stringDeserializer(), "raw_field_type");
        op.add(Builder::searchModelId, JsonpDeserializer.stringDeserializer(), "search_model_id");
        op.add(Builder::semanticFieldSearchAnalyzer, JsonpDeserializer.stringDeserializer(), "semantic_field_search_analyzer");
        op.add(Builder::semanticInfoFieldName, JsonpDeserializer.stringDeserializer(), "semantic_info_field_name");
        op.add(Builder::skipExistingEmbedding, JsonpDeserializer.booleanDeserializer(), "skip_existing_embedding");
        op.add(Builder::sparseEncodingConfig, SemanticSparseEncodingConfig._DESERIALIZER, "sparse_encoding_config");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.chunking);
        result = 31 * result + Objects.hashCode(this.denseEmbeddingConfig);
        result = 31 * result + this.modelId.hashCode();
        result = 31 * result + Objects.hashCode(this.rawFieldType);
        result = 31 * result + Objects.hashCode(this.searchModelId);
        result = 31 * result + Objects.hashCode(this.semanticFieldSearchAnalyzer);
        result = 31 * result + Objects.hashCode(this.semanticInfoFieldName);
        result = 31 * result + Objects.hashCode(this.skipExistingEmbedding);
        result = 31 * result + Objects.hashCode(this.sparseEncodingConfig);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticProperty other = (SemanticProperty)o;
        return Objects.equals(this.chunking, other.chunking) && Objects.equals(this.denseEmbeddingConfig, other.denseEmbeddingConfig) && this.modelId.equals(other.modelId) && Objects.equals(this.rawFieldType, other.rawFieldType) && Objects.equals(this.searchModelId, other.searchModelId) && Objects.equals(this.semanticFieldSearchAnalyzer, other.semanticFieldSearchAnalyzer) && Objects.equals(this.semanticInfoFieldName, other.semanticInfoFieldName) && Objects.equals(this.skipExistingEmbedding, other.skipExistingEmbedding) && Objects.equals(this.sparseEncodingConfig, other.sparseEncodingConfig);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SemanticProperty> {
        @Nullable
        private JsonData chunking;
        @Nullable
        private SemanticDenseEmbeddingConfig denseEmbeddingConfig;
        private String modelId;
        @Nullable
        private String rawFieldType;
        @Nullable
        private String searchModelId;
        @Nullable
        private String semanticFieldSearchAnalyzer;
        @Nullable
        private String semanticInfoFieldName;
        @Nullable
        private Boolean skipExistingEmbedding;
        @Nullable
        private SemanticSparseEncodingConfig sparseEncodingConfig;

        public Builder() {
        }

        private Builder(SemanticProperty o) {
            this.chunking = o.chunking;
            this.denseEmbeddingConfig = o.denseEmbeddingConfig;
            this.modelId = o.modelId;
            this.rawFieldType = o.rawFieldType;
            this.searchModelId = o.searchModelId;
            this.semanticFieldSearchAnalyzer = o.semanticFieldSearchAnalyzer;
            this.semanticInfoFieldName = o.semanticInfoFieldName;
            this.skipExistingEmbedding = o.skipExistingEmbedding;
            this.sparseEncodingConfig = o.sparseEncodingConfig;
        }

        private Builder(Builder o) {
            this.chunking = o.chunking;
            this.denseEmbeddingConfig = o.denseEmbeddingConfig;
            this.modelId = o.modelId;
            this.rawFieldType = o.rawFieldType;
            this.searchModelId = o.searchModelId;
            this.semanticFieldSearchAnalyzer = o.semanticFieldSearchAnalyzer;
            this.semanticInfoFieldName = o.semanticInfoFieldName;
            this.skipExistingEmbedding = o.skipExistingEmbedding;
            this.sparseEncodingConfig = o.sparseEncodingConfig;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder chunking(@Nullable JsonData value) {
            this.chunking = value;
            return this;
        }

        @Nonnull
        public final Builder denseEmbeddingConfig(@Nullable SemanticDenseEmbeddingConfig value) {
            this.denseEmbeddingConfig = value;
            return this;
        }

        @Nonnull
        public final Builder denseEmbeddingConfig(Function<SemanticDenseEmbeddingConfig.Builder, ObjectBuilder<SemanticDenseEmbeddingConfig>> fn) {
            return this.denseEmbeddingConfig(fn.apply(new SemanticDenseEmbeddingConfig.Builder()).build());
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder rawFieldType(@Nullable String value) {
            this.rawFieldType = value;
            return this;
        }

        @Nonnull
        public final Builder searchModelId(@Nullable String value) {
            this.searchModelId = value;
            return this;
        }

        @Nonnull
        public final Builder semanticFieldSearchAnalyzer(@Nullable String value) {
            this.semanticFieldSearchAnalyzer = value;
            return this;
        }

        @Nonnull
        public final Builder semanticInfoFieldName(@Nullable String value) {
            this.semanticInfoFieldName = value;
            return this;
        }

        @Nonnull
        public final Builder skipExistingEmbedding(@Nullable Boolean value) {
            this.skipExistingEmbedding = value;
            return this;
        }

        @Nonnull
        public final Builder sparseEncodingConfig(@Nullable SemanticSparseEncodingConfig value) {
            this.sparseEncodingConfig = value;
            return this;
        }

        @Nonnull
        public final Builder sparseEncodingConfig(Function<SemanticSparseEncodingConfig.Builder, ObjectBuilder<SemanticSparseEncodingConfig>> fn) {
            return this.sparseEncodingConfig(fn.apply(new SemanticSparseEncodingConfig.Builder()).build());
        }

        @Override
        @Nonnull
        public SemanticProperty build() {
            this._checkSingleUse();
            return new SemanticProperty(this);
        }
    }
}

