/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public abstract class KNNVectorValues<T> {
    protected final KNNVectorValuesIterator vectorValuesIterator;
    protected int dimension;
    protected int bytesPerVector;

    protected KNNVectorValues(KNNVectorValuesIterator vectorValuesIterator) {
        this.vectorValuesIterator = vectorValuesIterator;
    }

    public abstract T getVector() throws IOException;

    public abstract T conditionalCloneVector() throws IOException;

    public int dimension() {
        assert (this.docId() != -1 && this.dimension != 0) : "Cannot get dimension before we retrieve a vector from KNNVectorValues";
        return this.dimension;
    }

    public int bytesPerVector() {
        assert (this.docId() != -1 && this.bytesPerVector != 0) : "Cannot get bytesPerVector before we retrieve a vector from KNNVectorValues";
        return this.bytesPerVector;
    }

    @Deprecated
    public long totalLiveDocs() {
        return this.vectorValuesIterator.liveDocs();
    }

    public int docId() {
        return this.vectorValuesIterator.docId();
    }

    public int advance(int docId) throws IOException {
        return this.vectorValuesIterator.advance(docId);
    }

    public int nextDoc() throws IOException {
        return this.vectorValuesIterator.nextDoc();
    }

    @Generated
    public String toString() {
        return "KNNVectorValues(vectorValuesIterator=" + String.valueOf(this.vectorValuesIterator) + ", dimension=" + this.dimension + ", bytesPerVector=" + this.bytesPerVector + ")";
    }
}

