/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;

public class Pkcs11Lib
extends CrtResource {
    public Pkcs11Lib(String path) {
        this(path, InitializeFinalizeBehavior.DEFAULT);
    }

    public Pkcs11Lib(String path, InitializeFinalizeBehavior initializeFinalizeBehavior) {
        this.acquireNativeHandle(Pkcs11Lib.pkcs11LibNew(path, initializeFinalizeBehavior.nativeValue));
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            Pkcs11Lib.pkcs11LibRelease(this.getNativeHandle());
        }
    }

    private static native long pkcs11LibNew(String var0, int var1);

    private static native void pkcs11LibRelease(long var0);

    public static enum InitializeFinalizeBehavior {
        DEFAULT(0),
        OMIT(1),
        STRICT(2);

        int nativeValue;

        private InitializeFinalizeBehavior(int nativeValue) {
            this.nativeValue = nativeValue;
        }
    }
}

