"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.adAlerting = components.clientAction.namespaceFactory();
  const adAlerting = Client.prototype.adAlerting.prototype;
  adAlerting.searchMonitors = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  adAlerting.searchAlerts = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/alerts?size=${_constants.MAX_ALERTS}&monitorId=<%=monitorId%>&sortString=start_time&sortOrder=desc&searchString=start_time:[<%=startTime%>%20TO%20<%=endTime%>]`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        },
        startTime: {
          type: 'number',
          required: true
        },
        endTime: {
          type: 'number',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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