/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lang.DisposedException;
import com.sun.star.lib.uno.environments.remote.JavaThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.uno.RuntimeException;
import java.util.ArrayList;

public class JobQueue {
    private static final boolean DEBUG = false;
    final ArrayList<Job> jobList = new ArrayList();
    private ThreadId _threadId;
    protected int _ref_count = 0;
    private boolean _createThread;
    private boolean _createThread_now;
    private Thread _worker_thread;
    private JavaThreadPool _pool;
    JobQueue _async_jobQueue;
    protected JobQueue _sync_jobQueue;
    private boolean _active = false;
    private JavaThreadPoolFactory _javaThreadPoolFactory;

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = ThreadId.createFresh();
        this._sync_jobQueue = javaThreadPoolFactory.getJobQueue(threadId);
        if (this._sync_jobQueue == null) {
            this._sync_jobQueue = new JobQueue(javaThreadPoolFactory, threadId, true);
            this._sync_jobQueue.acquire();
        }
        this._sync_jobQueue._async_jobQueue = this;
        this._createThread = true;
        this._createThread_now = true;
        this.acquire();
    }

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId, boolean bl) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = threadId;
        this._createThread = bl;
        this._createThread_now = bl;
    }

    ThreadId getThreadId() {
        return this._threadId;
    }

    synchronized void acquire() {
        if (this._ref_count <= 0 && this._sync_jobQueue == null) {
            this._javaThreadPoolFactory.addJobQueue(this);
        }
        ++this._ref_count;
    }

    synchronized void release() {
        --this._ref_count;
        if (this._ref_count <= 0) {
            if (this._sync_jobQueue == null) {
                this._javaThreadPoolFactory.removeJobQueue(this);
            }
            if (this._sync_jobQueue != null) {
                this._sync_jobQueue._async_jobQueue = null;
                this._sync_jobQueue.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job removeJob(int n) {
        Job job = null;
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            boolean bl = false;
            while (this.jobList.isEmpty() && (n == 0 || !bl)) {
                Throwable throwable = this._pool.checkDisposed();
                if (throwable != null) {
                    throw (DisposedException)new DisposedException().initCause(throwable);
                }
                this.notifyAll();
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                }
                bl = true;
            }
            if (!this.jobList.isEmpty()) {
                job = this.jobList.remove(0);
                this._active = true;
            }
        }
        if (job != null && this._async_jobQueue != null) {
            jobQueue = this._async_jobQueue;
            synchronized (jobQueue) {
                while (this._async_jobQueue._active || !this._async_jobQueue.jobList.isEmpty()) {
                    Throwable throwable = this._pool.checkDisposed();
                    if (throwable != null) {
                        throw (DisposedException)new DisposedException().initCause(throwable);
                    }
                    try {
                        this._async_jobQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                    }
                }
            }
        }
        return job;
    }

    synchronized void putJob(Job job, JavaThreadPool javaThreadPool) {
        this.jobList.add(job);
        if (this._worker_thread == null && this._createThread && this._createThread_now) {
            this.acquire();
            this._createThread_now = false;
            new JobDispatcher(javaThreadPool).start();
        }
        this.notifyAll();
    }

    Object enter(JavaThreadPool javaThreadPool) throws Throwable {
        return this.enter(0, javaThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enter(int n, JavaThreadPool javaThreadPool) throws Throwable {
        JavaThreadPool javaThreadPool2;
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            javaThreadPool2 = this._pool;
            this._pool = javaThreadPool;
        }
        object = null;
        Thread thread = this._worker_thread;
        this._worker_thread = Thread.currentThread();
        while (!bl) {
            Job job = null;
            try {
                job = this.removeJob(n);
                if (job != null) {
                    try {
                        object = job.execute();
                    }
                    finally {
                        this._active = false;
                    }
                    if (!job.isRequest()) {
                        job.dispose();
                        bl = true;
                    }
                    job = null;
                    continue;
                }
                bl = true;
            }
            finally {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    if (job != null || bl && this.jobList.isEmpty()) {
                        this._worker_thread = thread;
                        this._createThread_now = true;
                        this._pool = javaThreadPool2;
                        if (this._sync_jobQueue != null) {
                            this.notifyAll();
                        }
                    } else {
                        bl = false;
                    }
                }
            }
        }
        return object;
    }

    synchronized void notifyAboutSomeDisposedPool() {
        if (this._sync_jobQueue == null) {
            this.notifyAll();
        }
    }

    class JobDispatcher
    extends Thread {
        JavaThreadPool _pool;

        JobDispatcher(JavaThreadPool javaThreadPool) {
            super("JobDispatcher");
            this._pool = javaThreadPool;
        }

        ThreadId getThreadId() {
            return JobQueue.this._threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JobQueue.this.enter(2000, this._pool);
            }
            catch (Throwable throwable) {
                JobQueue jobQueue = JobQueue.this;
                synchronized (jobQueue) {
                    if (!JobQueue.this.jobList.isEmpty() || JobQueue.this._active) {
                        System.err.println(this.getClass().getName() + " - exception occurred:" + throwable);
                        throwable.printStackTrace(System.err);
                    }
                }
            }
            finally {
                JobQueue.this.release();
            }
        }
    }
}

