/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;

public class SubscribedTopicDescriberImpl
implements SubscribedTopicDescriber {
    private final CoordinatorMetadataImage metadataImage;

    public SubscribedTopicDescriberImpl(CoordinatorMetadataImage metadataImage) {
        this.metadataImage = Objects.requireNonNull(metadataImage);
    }

    public int numPartitions(Uuid topicId) {
        return this.metadataImage.topicMetadata(topicId).map(CoordinatorMetadataImage.TopicMetadata::partitionCount).orElse(-1);
    }

    public Set<String> racksForPartition(Uuid topicId, int partition) {
        Optional topicMetadataOp = this.metadataImage.topicMetadata(topicId);
        if (topicMetadataOp.isEmpty()) {
            return Set.of();
        }
        CoordinatorMetadataImage.TopicMetadata topicMetadata = (CoordinatorMetadataImage.TopicMetadata)topicMetadataOp.get();
        List racks = topicMetadata.partitionRacks(partition);
        if (racks == null) {
            return Set.of();
        }
        return new HashSet<String>(racks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedTopicDescriberImpl that = (SubscribedTopicDescriberImpl)o;
        return this.metadataImage.equals((Object)that.metadataImage);
    }

    public int hashCode() {
        return Objects.hashCode(this.metadataImage);
    }

    public String toString() {
        return "SubscribedTopicMetadata(metadataImage=" + String.valueOf(this.metadataImage) + ")";
    }
}

