/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import kafka.server.ControllerRegistrationManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUf\u0001\u0002\"D\u0001!C\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005I\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003k\u0011!1\bA!b\u0001\n\u00039\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0013\u0005\u0005\u0001A!b\u0001\n\u0003I\u0007\"CA\u0002\u0001\t\u0005\t\u0015!\u0003k\u0011)\t)\u0001\u0001BC\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\u0014\u0001\t\u0015\r\u0011\"\u0001\u0002*!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!a\u000b\t\u0015\u0005U\u0002A!b\u0001\n\u0003\t9\u0004\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003sA!\"!\u0011\u0001\u0005\u000b\u0007I\u0011AA\"\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011Q\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001b\u0001\t\u0013\t9\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0001\u0002n!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0007C\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002z!I\u0011\u0011\u0011\u0001A\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003\u001f\u0003\u0001\u0015)\u0003\u0002|!I\u0011\u0011\u0013\u0001A\u0002\u0013\u0005\u00111\u0013\u0005\n\u00037\u0003\u0001\u0019!C\u0001\u0003;C\u0001\"!)\u0001A\u0003&\u0011Q\u0013\u0005\n\u0003G\u0003\u0001\u0019!C\u0001\u0003'C\u0011\"!*\u0001\u0001\u0004%\t!a*\t\u0011\u0005-\u0006\u0001)Q\u0005\u0003+C\u0011\"!,\u0001\u0001\u0004%I!a,\t\u0013\u0005\r\u0007\u00011A\u0005\n\u0005\u0015\u0007\u0002CAe\u0001\u0001\u0006K!!-\t\u0013\u0005-\u0007\u00011A\u0005\u0002\u0005e\u0004\"CAg\u0001\u0001\u0007I\u0011AAh\u0011!\t\u0019\u000e\u0001Q!\n\u0005m\u0004bCAk\u0001\u0001\u0007\t\u0019!C\u0005\u0003/D1\"a8\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002b\"Y\u0011Q\u001d\u0001A\u0002\u0003\u0005\u000b\u0015BAm\u0011)\t9\u000f\u0001b\u0001\n\u0003\u0019\u0015\u0011\u001e\u0005\t\u0003o\u0004\u0001\u0015!\u0003\u0002l\u001a1\u0011\u0011 \u0001\u0005\u0003wDq!!\u0014+\t\u0003\u00119\u0002C\u0004\u0003\u001e)\"\tEa\b\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$!9!\u0011\u0006\u0001\u0005\u0002\t}\u0001b\u0002B\u0016\u0001\u0011\u0005#q\u0004\u0005\b\u0005[\u0001A\u0011\tB\u0018\r\u0019\u00119\u0006\u0001\u0003\u0003Z!Q!1G\u0019\u0003\u0002\u0003\u0006IA!\u000e\t\u0015\t}\u0012G!A!\u0002\u0013\u0011\t\u0005C\u0004\u0002NE\"\tAa\u0017\t\u000f\tu\u0011\u0007\"\u0011\u0003 !9!1\r\u0001\u0005\n\t}\u0001b\u0002B3\u0001\u0011%!q\u0004\u0004\u0007\u0005O\u0002AA!\u001b\t\u000f\u00055\u0003\b\"\u0001\u0003r!9!Q\u000f\u001d\u0005B\t]\u0004b\u0002BEq\u0011\u0005#q\u0004\u0005\b\u0005\u0017\u0003A\u0011\u0002B\u0010\u0011\u001d\u0011i\t\u0001C\u0005\u0005\u001f;\u0011B!&D\u0003\u0003E\tAa&\u0007\u0011\t\u001b\u0015\u0011!E\u0001\u00053Cq!!\u0014@\t\u0003\u0011Y\nC\u0005\u0003\u001e~\n\n\u0011\"\u0001\u0003 \ni2i\u001c8ue>dG.\u001a:SK\u001eL7\u000f\u001e:bi&|g.T1oC\u001e,'O\u0003\u0002E\u000b\u000611/\u001a:wKJT\u0011AR\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011jT+\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\r\u0005s\u0017PU3g!\t\u00016+D\u0001R\u0015\t\u0011V)A\u0003vi&d7/\u0003\u0002U#\n9Aj\\4hS:<\u0007C\u0001,a\u001b\u00059&B\u0001-Z\u0003%\u0001XO\u00197jg\",'O\u0003\u0002[7\u0006)\u0011.\\1hK*\u0011a\t\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b/\n\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\r9|G-Z%e+\u0005!\u0007C\u0001&f\u0013\t17JA\u0002J]R\fqA\\8eK&#\u0007%A\u0005dYV\u001cH/\u001a:JIV\t!\u000e\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[.k\u0011A\u001c\u0006\u0003_\u001e\u000ba\u0001\u0010:p_Rt\u0014BA9L\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\\\u0015AC2mkN$XM]%eA\u0005!A/[7f+\u0005A\bCA=~\u001b\u0005Q(B\u0001*|\u0015\ta8,\u0001\u0004d_6lwN\\\u0005\u0003}j\u0014A\u0001V5nK\u0006)A/[7fA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013!E:vaB|'\u000f^3e\r\u0016\fG/\u001e:fgV\u0011\u0011\u0011\u0002\t\b\u0003\u0017\t)B[A\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001B;uS2T!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tiAA\u0002NCB\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?Y\u0016\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\r\u0012Q\u0004\u0002\r-\u0016\u00148/[8o%\u0006tw-Z\u0001\u0013gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001c\b%A\u0007j]\u000e\f'O\\1uS>t\u0017\nZ\u000b\u0003\u0003W\u0001B!!\f\u000205\t10C\u0002\u00022m\u0014A!V;jI\u0006q\u0011N\\2be:\fG/[8o\u0013\u0012\u0004\u0013\u0001\u00047jgR,g.\u001a:J]\u001a|WCAA\u001d!\u0011\tY\"a\u000f\n\t\u0005u\u0012Q\u0004\u0002\r\u0019&\u001cH/\u001a8fe&sgm\\\u0001\u000eY&\u001cH/\u001a8fe&sgm\u001c\u0011\u00021I,7/\u001a8e\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0006\u0002\u0002FA\u0019\u00110a\u0012\n\u0007\u0005%#P\u0001\nFqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0017!\u0007:fg\u0016tG-\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u0002\na\u0001P5oSRtDCEA)\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1\u0003G\u00022!a\u0015\u0001\u001b\u0005\u0019\u0005\"\u00022\u0012\u0001\u0004!\u0007\"\u00025\u0012\u0001\u0004Q\u0007\"\u0002<\u0012\u0001\u0004A\bBBA\u0001#\u0001\u0007!\u000eC\u0004\u0002\u0006E\u0001\r!!\u0003\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002,!9\u0011QG\tA\u0002\u0005e\u0002\"CA!#A\u0005\t\u0019AA#\u0003\u0011q\u0017-\\3\u0015\u0003)\f\u0011\u0002\\8h!J,g-\u001b=\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0002pA\u0019\u00110!\u001d\n\u0007\u0005M$P\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005Q\u0001/\u001a8eS:<'\u000b]2\u0016\u0005\u0005m\u0004c\u0001&\u0002~%\u0019\u0011qP&\u0003\u000f\t{w\u000e\\3b]\u0006q\u0001/\u001a8eS:<'\u000b]2`I\u0015\fH\u0003BAC\u0003\u0017\u00032ASAD\u0013\r\tIi\u0013\u0002\u0005+:LG\u000fC\u0005\u0002\u000e^\t\t\u00111\u0001\u0002|\u0005\u0019\u0001\u0010J\u0019\u0002\u0017A,g\u000eZ5oOJ\u00038\rI\u0001\u000fgV\u001c7-Z:tMVd'\u000b]2t+\t\t)\nE\u0002K\u0003/K1!!'L\u0005\u0011auN\\4\u0002%M,8mY3tg\u001a,HN\u00159dg~#S-\u001d\u000b\u0005\u0003\u000b\u000by\nC\u0005\u0002\u000ej\t\t\u00111\u0001\u0002\u0016\u0006y1/^2dKN\u001ch-\u001e7Sa\u000e\u001c\b%\u0001\u0006gC&dW\r\u001a*qGN\faBZ1jY\u0016$'\u000b]2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0006%\u0006\"CAG;\u0005\u0005\t\u0019AAK\u0003-1\u0017-\u001b7fIJ\u00038m\u001d\u0011\u0002\u001f5,G/\u00193bi\u00064VM]:j_:,\"!!-\u0011\u000b)\u000b\u0019,a.\n\u0007\u0005U6J\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*\u0019A0!0\u000b\u0005\u0011[\u0016\u0002BAa\u0003w\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0014[\u0016$\u0018\rZ1uCZ+'o]5p]~#S-\u001d\u000b\u0005\u0003\u000b\u000b9\rC\u0005\u0002\u000e\u0002\n\t\u00111\u0001\u00022\u0006\u0001R.\u001a;bI\u0006$\u0018MV3sg&|g\u000eI\u0001\u0010e\u0016<\u0017n\u001d;fe\u0016$\u0017J\u001c'pO\u0006\u0019\"/Z4jgR,'/\u001a3J]2{wm\u0018\u0013fcR!\u0011QQAi\u0011%\tiiIA\u0001\u0002\u0004\tY(\u0001\tsK\u001eL7\u000f^3sK\u0012Le\u000eT8hA\u0005yql\u00195b]:,G.T1oC\u001e,'/\u0006\u0002\u0002ZB!\u0011\u0011XAn\u0013\u0011\ti.a/\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018aE0dQ\u0006tg.\u001a7NC:\fw-\u001a:`I\u0015\fH\u0003BAC\u0003GD\u0011\"!$'\u0003\u0003\u0005\r!!7\u0002!}\u001b\u0007.\u00198oK2l\u0015M\\1hKJ\u0004\u0013AC3wK:$\u0018+^3vKV\u0011\u00111\u001e\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011_.\u0002\u000bE,X-^3\n\t\u0005U\u0018q\u001e\u0002\u0010\u0017\u000647.Y#wK:$\u0018+^3vK\u0006YQM^3oiF+X-^3!\u00055\u0019\u0006.\u001e;e_^tWI^3oiN)!&!@\u0003\nA!\u0011q B\u0003\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\u0005E\u0011\u0001\u00027b]\u001eLAAa\u0002\u0003\u0002\t1qJ\u00196fGR\u0004BAa\u0003\u0003\u00129!\u0011Q\u001eB\u0007\u0013\u0011\u0011y!a<\u0002\u0015\u00153XM\u001c;Rk\u0016,X-\u0003\u0003\u0003\u0014\tU!!B#wK:$(\u0002\u0002B\b\u0003_$\"A!\u0007\u0011\u0007\tm!&D\u0001\u0001\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u000b\u000bQa\u001d;beR$B!!\"\u0003&!9!qE\u0017A\u0002\u0005e\u0017AD2iC:tW\r\\'b]\u0006<WM]\u0001\u000eE\u0016<\u0017N\\*ikR$wn\u001e8\u0002\u000b\rdwn]3\u0002!=tW*\u001a;bI\u0006$\u0018-\u00169eCR,G\u0003CAC\u0005c\u0011iDa\u0012\t\u000f\tM\u0002\u00071\u0001\u00036\u0005)A-\u001a7uCB!!q\u0007B\u001d\u001b\u0005I\u0016b\u0001B\u001e3\niQ*\u001a;bI\u0006$\u0018\rR3mi\u0006DqAa\u00101\u0001\u0004\u0011\t%\u0001\u0005oK^LU.Y4f!\u0011\u00119Da\u0011\n\u0007\t\u0015\u0013LA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\b\u0005\u0013\u0002\u0004\u0019\u0001B&\u0003!i\u0017M\\5gKN$\b\u0003\u0002B'\u0005'j!Aa\u0014\u000b\u0007\tE\u0013,\u0001\u0004m_\u0006$WM]\u0005\u0005\u0005+\u0012yE\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0003'5+G/\u00193bi\u0006,\u0006\u000fZ1uK\u00163XM\u001c;\u0014\u000bE\niP!\u0003\u0015\r\tu#q\fB1!\r\u0011Y\"\r\u0005\b\u0005g!\u0004\u0019\u0001B\u001b\u0011\u001d\u0011y\u0004\u000ea\u0001\u0005\u0003\nq$\\1zE\u0016\u001cVM\u001c3D_:$(o\u001c7mKJ\u0014VmZ5tiJ\fG/[8o\u0003i\u0019XM\u001c3D_:$(o\u001c7mKJ\u0014VmZ5tiJ\fG/[8o\u0005m\u0011VmZ5tiJ\fG/[8o%\u0016\u001c\bo\u001c8tK\"\u000bg\u000e\u001a7feN)\u0001(!@\u0003lA!\u0011\u0011\u0018B7\u0013\u0011\u0011y'a/\u0003E\r{g\u000e\u001e:pY2,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s)\t\u0011\u0019\bE\u0002\u0003\u001ca\n!b\u001c8D_6\u0004H.\u001a;f)\u0011\t)I!\u001f\t\u000f\tm$\b1\u0001\u0003~\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019iW\u0001\bG2LWM\u001c;t\u0013\u0011\u00119I!!\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0006IqN\u001c+j[\u0016|W\u000f^\u0001&g\u000eDW\rZ;mK:+\u0007\u0010^\"p[6,h.[2bi&|g.\u00114uKJ4\u0015-\u001b7ve\u0016\f\u0011d]2iK\u0012,H.\u001a(fqR\u001cu.\\7v]&\u001c\u0017\r^5p]R!\u0011Q\u0011BI\u0011\u001d\u0011\u0019*\u0010a\u0001\u0003+\u000b!\"\u001b8uKJ4\u0018\r\\'t\u0003u\u0019uN\u001c;s_2dWM\u001d*fO&\u001cHO]1uS>tW*\u00198bO\u0016\u0014\bcAA*\u007fM\u0011q(\u0013\u000b\u0003\u0005/\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTC\u0001BQU\u0011\t)Ea),\u0005\t\u0015\u0006\u0003\u0002BT\u0005ck!A!+\u000b\t\t-&QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa,L\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005g\u0013IKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ControllerRegistrationManager
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final String clusterId;
    private final Time time;
    private final String threadNamePrefix;
    private final Map<String, VersionRange> supportedFeatures;
    private final Uuid incarnationId;
    private final ListenerInfo listenerInfo;
    private final ExponentialBackoff resendExponentialBackoff;
    private final LogContext logContext;
    private boolean pendingRpc;
    private long successfulRpcs;
    private long failedRpcs;
    private Option<MetadataVersion> kafka$server$ControllerRegistrationManager$$metadataVersion;
    private boolean registeredInLog;
    private NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager;
    private final KafkaEventQueue eventQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ExponentialBackoff $lessinit$greater$default$8() {
        return ControllerRegistrationManager$.MODULE$.$lessinit$greater$default$8();
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Time time() {
        return this.time;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public ListenerInfo listenerInfo() {
        return this.listenerInfo;
    }

    public ExponentialBackoff resendExponentialBackoff() {
        return this.resendExponentialBackoff;
    }

    public String name() {
        return "ControllerRegistrationManager";
    }

    private String logPrefix() {
        StringBuilder builder = new StringBuilder("[ControllerRegistrationManager");
        builder.append(" id=").append(this.nodeId());
        builder.append(" incarnation=").append((Object)this.incarnationId());
        builder.append("] ");
        return builder.toString();
    }

    public LogContext logContext() {
        return this.logContext;
    }

    public boolean pendingRpc() {
        return this.pendingRpc;
    }

    public void pendingRpc_$eq(boolean x$1) {
        this.pendingRpc = x$1;
    }

    public long successfulRpcs() {
        return this.successfulRpcs;
    }

    public void successfulRpcs_$eq(long x$1) {
        this.successfulRpcs = x$1;
    }

    public long failedRpcs() {
        return this.failedRpcs;
    }

    public void failedRpcs_$eq(long x$1) {
        this.failedRpcs = x$1;
    }

    private Option<MetadataVersion> metadataVersion() {
        return this.kafka$server$ControllerRegistrationManager$$metadataVersion;
    }

    public void kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(Option<MetadataVersion> x$1) {
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = x$1;
    }

    public boolean registeredInLog() {
        return this.registeredInLog;
    }

    public void registeredInLog_$eq(boolean x$1) {
        this.registeredInLog = x$1;
    }

    public NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager() {
        return this.kafka$server$ControllerRegistrationManager$$_channelManager;
    }

    public void kafka$server$ControllerRegistrationManager$$_channelManager_$eq(NodeToControllerChannelManager x$1) {
        this.kafka$server$ControllerRegistrationManager$$_channelManager = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    /*
     * WARNING - void declaration
     */
    public void start(NodeToControllerChannelManager channelManager) {
        void append_event;
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        EventQueue.Event event = () -> {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "initialized channel manager.");
                this.kafka$server$ControllerRegistrationManager$$_channelManager_$eq(channelManager);
                this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "start error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        };
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (UnaryOperator)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown");
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    /*
     * WARNING - void declaration
     */
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null || delta.clusterDelta() != null && delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.nodeId()))) {
            void append_event;
            KafkaEventQueue kafkaEventQueue = this.eventQueue();
            MetadataUpdateEvent metadataUpdateEvent = new MetadataUpdateEvent(this, delta, newImage);
            if (kafkaEventQueue == null) {
                throw null;
            }
            kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (UnaryOperator)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
            return;
        }
    }

    public void kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration() {
        Option<MetadataVersion> metadataVersion = this.metadataVersion();
        if (this.registeredInLog()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: controller is already registered.");
            return;
        }
        if (this.kafka$server$ControllerRegistrationManager$$_channelManager() == null) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the channel manager has not been initialized.");
            return;
        }
        if (metadataVersion.isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the metadata.version is not known yet.");
            return;
        }
        if (!((MetadataVersion)metadataVersion.get()).isControllerRegistrationSupported()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the metadata.version is still " + metadataVersion + ", which does not support KIP-919 controller registration.");
            return;
        }
        if (this.pendingRpc()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: waiting for the previous RPC to complete.");
            return;
        }
        this.sendControllerRegistration();
    }

    private void sendControllerRegistration() {
        ControllerRegistrationRequestData.FeatureCollection features = new ControllerRegistrationRequestData.FeatureCollection();
        CollectionConverters$.MODULE$.MapHasAsScala(this.supportedFeatures()).asScala().foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerRegistrationManager.$anonfun$sendControllerRegistration$1(features, x0$1)));
        ControllerRegistrationRequestData data = new ControllerRegistrationRequestData().setControllerId(this.nodeId()).setFeatures(features).setIncarnationId(this.incarnationId()).setListeners(this.listenerInfo().toControllerRegistrationRequest()).setZkMigrationReady(false);
        this.info((Function0<String>)(Function0 & Serializable)() -> "sendControllerRegistration: attempting to send " + data);
        this.kafka$server$ControllerRegistrationManager$$_channelManager().sendRequest((AbstractRequest.Builder)new ControllerRegistrationRequest.Builder(data), (ControllerRequestCompletionHandler)new RegistrationResponseHandler());
        this.pendingRpc_$eq(true);
    }

    public void kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure() {
        long delayMs = this.resendExponentialBackoff().backoff(this.failedRpcs());
        this.failedRpcs_$eq(this.failedRpcs() + 1L);
        this.scheduleNextCommunication(delayMs);
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleNextCommunication(long intervalMs) {
        void scheduleDeferred_event;
        void scheduleDeferred_deadlineNsCalculator;
        void scheduleDeferred_tag;
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Scheduling next communication at " + intervalMs + " ms from now.");
        long deadlineNs = this.time().nanoseconds() + TimeUnit.MILLISECONDS.toNanos(intervalMs);
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        EventQueue.Event event = () -> this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
        EventQueue.DeadlineFunction deadlineFunction = new EventQueue.DeadlineFunction(deadlineNs);
        String string = "communication";
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.DEFERRED, (String)scheduleDeferred_tag, (UnaryOperator)scheduleDeferred_deadlineNsCalculator, (EventQueue.Event)scheduleDeferred_event);
    }

    public static final /* synthetic */ boolean $anonfun$sendControllerRegistration$1(ControllerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            VersionRange range = (VersionRange)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new ControllerRegistrationRequestData.Feature().setName(name).setMinSupportedVersion(range.min()).setMaxSupportedVersion(range.max()));
        }
        throw new MatchError(null);
    }

    public ControllerRegistrationManager(int nodeId, String clusterId, Time time, String threadNamePrefix, Map<String, VersionRange> supportedFeatures, Uuid incarnationId, ListenerInfo listenerInfo, ExponentialBackoff resendExponentialBackoff) {
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.supportedFeatures = supportedFeatures;
        this.incarnationId = incarnationId;
        this.listenerInfo = listenerInfo;
        this.resendExponentialBackoff = resendExponentialBackoff;
        this.logContext = new LogContext(this.logPrefix());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.pendingRpc = false;
        this.successfulRpcs = 0L;
        this.failedRpcs = 0L;
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = None$.MODULE$;
        this.registeredInLog = false;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), threadNamePrefix + "registration-manager-", (EventQueue.Event)new ShutdownEvent());
    }

    private class MetadataUpdateEvent
    implements EventQueue.Event {
        private final MetadataDelta delta;
        private final MetadataImage newImage;
        public final /* synthetic */ ControllerRegistrationManager $outer;

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                if (this.delta.featuresDelta() != null) {
                    this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$metadataVersion_$eq((Option<MetadataVersion>)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.newImage.features().metadataVersion())));
                }
                if (this.delta.clusterDelta() != null && this.delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()))) {
                    ControllerRegistration curRegistration = (ControllerRegistration)this.newImage.cluster().controllers().get(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()));
                    if (curRegistration == null) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "Registration removed for this node ID.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else if (!curRegistration.incarnationId().equals((Object)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().incarnationId())) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "Found registration for " + curRegistration.incarnationId() + " instead of our incarnation.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "Our registration has been persisted to the metadata log.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(true);
                    }
                }
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "onMetadataUpdate error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer() {
            return this.$outer;
        }

        public MetadataUpdateEvent(ControllerRegistrationManager $outer, MetadataDelta delta, MetadataImage newImage) {
            this.delta = delta;
            this.newImage = newImage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class RegistrationResponseHandler
    implements ControllerRequestCompletionHandler {
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().pendingRpc_$eq(false);
            if (response.authenticationException() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: authentication error", (Function0<Throwable>)(Function0 & Serializable)() -> response.authenticationException());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: unsupported API version error", (Function0<Throwable>)(Function0 & Serializable)() -> response.versionMismatch());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: unknown error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof ControllerRegistrationResponse)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: invalid response type error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            ControllerRegistrationResponse message = (ControllerRegistrationResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode((short)message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs_$eq(this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs() + 1L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().failedRpcs_$eq(0L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: controller acknowledged ControllerRegistrationRequest.");
                return;
            }
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: controller returned error " + errorCode + " (" + message.data().errorMessage() + ")");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public void onTimeout() {
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: channel manager timed out before sending the request.");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public RegistrationResponseHandler() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }

    private class ShutdownEvent
    implements EventQueue.Event {
        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "shutting down.");
                if (this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager() != null) {
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager().shutdown();
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager_$eq(null);
                }
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "ControllerRegistrationManager.stop error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public ShutdownEvent() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }
}

