/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelProviderKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/ide/impl/wsl/WslEelMachine;", "Lcom/intellij/platform/eel/EelMachine;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "osFamily", "Lcom/intellij/platform/eel/EelOsFamily;", "getOsFamily", "()Lcom/intellij/platform/eel/EelOsFamily;", "name", "", "Lorg/jetbrains/annotations/NonNls;", "getName", "()Ljava/lang/String;", "toEelApi", "Lcom/intellij/platform/eel/EelApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "intellij.platform.ide.impl.wsl"})
public final class WslEelMachine
implements EelMachine {
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final EelOsFamily osFamily;
    @NotNull
    private final String name;

    public WslEelMachine(@NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        this.distribution = distribution;
        this.osFamily = EelOsFamily.Posix;
        this.name = "WSL: " + this.distribution.getPresentableName();
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public EelOsFamily getOsFamily() {
        return this.osFamily;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object toEelApi(@NotNull EelDescriptor descriptor, @NotNull Continuation<? super EelApi> $completion) {
        if (!(descriptor instanceof WslEelDescriptor && Intrinsics.areEqual((Object)((WslEelDescriptor)descriptor).getMachine(), (Object)this))) {
            boolean bl = false;
            String string = "Wrong descriptor: " + descriptor + " for machine: " + this;
            throw new IllegalStateException(string.toString());
        }
        return WslEelProviderKt.access$getIjent(this.distribution, descriptor, $completion);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.ide.impl.wsl.WslEelMachine");
        WslEelMachine cfr_ignored_0 = (WslEelMachine)object2;
        if (!Intrinsics.areEqual((Object)this.distribution, (Object)((WslEelMachine)other).distribution)) {
            return false;
        }
        return this.getOsFamily() == ((WslEelMachine)other).getOsFamily();
    }

    public int hashCode() {
        int result = this.distribution.hashCode();
        result = 31 * result + this.getOsFamily().hashCode();
        return result;
    }
}

