/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameRuleValidator
extends CustomValidationRule {
    @Override
    @NotNull
    public String getRuleId() {
        return "class_name";
    }

    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return "dialog_class".equals(ruleId) || "quick_fix_class_name".equals(ruleId) || this.getRuleId().equals(ruleId);
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (data == null) {
            ClassNameRuleValidator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ClassNameRuleValidator.$$$reportNull$$$0(1);
        }
        if (ClassNameRuleValidator.isThirdPartyValue(data)) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                ClassNameRuleValidator.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(ClassNameRuleValidator.getClassName(data));
        context.setPayload(PLUGIN_INFO, (Object)info);
        if (info.getType() == PluginType.UNKNOWN) {
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                ClassNameRuleValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        if (validationResultType == null) {
            ClassNameRuleValidator.$$$reportNull$$$0(4);
        }
        return validationResultType;
    }

    @NotNull
    private static String getClassName(@NotNull String data) {
        int i;
        if (data == null) {
            ClassNameRuleValidator.$$$reportNull$$$0(5);
        }
        if ((i = data.indexOf("$$Lambda")) == -1) {
            String string = data;
            if (string == null) {
                ClassNameRuleValidator.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = data.substring(0, i);
        if (string == null) {
            ClassNameRuleValidator.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/ClassNameRuleValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/ClassNameRuleValidator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

