/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.terminal.ArrayTerminalDataStream;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.emulator.JediEmulator;
import com.jediterm.terminal.model.JediTerminal;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jediterm/terminal/emulator/SynchronizedOutput;", "", "dataStream", "Lcom/jediterm/terminal/TerminalDataStream;", "terminal", "Lcom/jediterm/terminal/Terminal;", "<init>", "(Lcom/jediterm/terminal/TerminalDataStream;Lcom/jediterm/terminal/Terminal;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "startTime", "", "ended", "", "await", "", "addChar", "ch", "", "end", "applySyncOutput", "output", "", "Lcom/jediterm/terminal/model/JediTerminal;", "Companion", "core"})
public final class SynchronizedOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalDataStream dataStream;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final StringBuilder buffer;
    private final long startTime;
    private boolean ended;
    @NotNull
    private static final String BEGIN_SYNC_OUTPUT_CSI = "\u001b[?2026h";
    @NotNull
    private static final String END_SYNC_OUTPUT_CSI = "\u001b[?2026l";
    private static final int TIMEOUT_MILLIS = 500;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    @NotNull
    private static final Logger LOG;

    public SynchronizedOutput(@NotNull TerminalDataStream dataStream, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.dataStream = dataStream;
        this.terminal = terminal;
        this.buffer = new StringBuilder(8192);
        this.startTime = System.currentTimeMillis();
    }

    public final void await() {
        while (!this.ended) {
            try {
                char ch = this.dataStream.getChar();
                this.addChar(ch);
            }
            catch (IOException e) {
                LOG.info("Aborting synchronized output", (Throwable)e);
                this.end();
            }
        }
    }

    private final void addChar(char ch) {
        if (this.ended) {
            throw new IllegalStateException("Synchronized output already ended");
        }
        this.buffer.append(ch);
        SynchronizedOutput.Companion.dropSuffix(this.buffer, BEGIN_SYNC_OUTPUT_CSI);
        if (SynchronizedOutput.Companion.dropSuffix(this.buffer, END_SYNC_OUTPUT_CSI)) {
            this.end();
        } else if (this.buffer.length() > 0x100000) {
            LOG.debug("Buffer size exceeded, aborting synchronized output");
            this.end();
        } else if (System.currentTimeMillis() - this.startTime > 500L) {
            LOG.debug("Timeout exceeded, aborting synchronized output");
            this.end();
        }
    }

    private final void end() {
        if (this.ended) {
            throw new IllegalStateException("Synchronized output already ended");
        }
        this.ended = true;
        char[] charArray = SynchronizedOutput.Companion.getCharArray(this.buffer);
        if (!(this.terminal instanceof JediTerminal)) {
            this.dataStream.pushBackBuffer(charArray, charArray.length);
        } else {
            ((JediTerminal)this.terminal).getTerminalTextBuffer().modify((Function0<Unit>)((Function0)() -> SynchronizedOutput.end$lambda$0(this, charArray)));
        }
    }

    private final void applySyncOutput(char[] output, JediTerminal terminal) {
        ArrayTerminalDataStream bufferDataStream = new ArrayTerminalDataStream(output, 0, output.length);
        JediEmulator newEmulator = new JediEmulator(bufferDataStream, terminal);
        try {
            while (true) {
                char ch = bufferDataStream.getChar();
                newEmulator.processChar(ch, terminal);
            }
        }
        catch (TerminalDataStream.EOF ch) {
        }
        catch (Exception e) {
            LOG.error("Error applying synchronized output", (Throwable)e);
        }
    }

    private static final Unit end$lambda$0(SynchronizedOutput this$0, char[] $charArray) {
        this$0.applySyncOutput($charArray, (JediTerminal)this$0.terminal);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SynchronizedOutput.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u0013*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/jediterm/terminal/emulator/SynchronizedOutput$Companion;", "", "<init>", "()V", "BEGIN_SYNC_OUTPUT_CSI", "", "END_SYNC_OUTPUT_CSI", "TIMEOUT_MILLIS", "", "MAX_BUFFER_SIZE", "LOG", "Lorg/slf4j/Logger;", "charArray", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getCharArray", "(Ljava/lang/StringBuilder;)[C", "dropSuffix", "", "suffix", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final char[] getCharArray(StringBuilder $this$charArray) {
            char[] cArray;
            char[] it = cArray = new char[$this$charArray.length()];
            boolean bl = false;
            $this$charArray.getChars(0, $this$charArray.length(), it, 0);
            return cArray;
        }

        private final boolean dropSuffix(StringBuilder $this$dropSuffix, String suffix) {
            if (StringsKt.endsWith$default((CharSequence)$this$dropSuffix, (CharSequence)suffix, (boolean)false, (int)2, null)) {
                $this$dropSuffix.delete($this$dropSuffix.length() - suffix.length(), $this$dropSuffix.length());
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

