/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ProcessAttachingConnector;
import com.jetbrains.jdi.RawCommandLineLauncher;
import com.jetbrains.jdi.SharedMemoryAttachingConnector;
import com.jetbrains.jdi.SharedMemoryListeningConnector;
import com.jetbrains.jdi.SocketAttachingConnector;
import com.jetbrains.jdi.SocketListeningConnector;
import com.jetbrains.jdi.SunCommandLineLauncher;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.jetbrains.jdi.VirtualMachineManagerService;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.spi.Connection;
import java.io.IOException;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class VirtualMachineManagerImpl
implements VirtualMachineManagerService {
    public static boolean TEST = false;
    private final List<Connector> connectors = new ArrayList<Connector>();
    private LaunchingConnector defaultConnector = null;
    private final List<VirtualMachine> targets = new ArrayList<VirtualMachine>();
    private final ThreadGroup mainGroupForJDI;
    private ResourceBundle messages = null;
    private int vmSequenceNumber = 0;
    private static final int majorVersion = 9;
    private static final int minorVersion = 0;
    private static final Object lock = new Object();
    private static VirtualMachineManagerImpl vmm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualMachineManagerImpl virtualMachineManager() {
        Object object = lock;
        synchronized (object) {
            if (vmm == null) {
                vmm = new VirtualMachineManagerImpl();
            }
        }
        return vmm;
    }

    public static VirtualMachineManagerImpl testVirtualMachineManager() {
        TEST = true;
        return VirtualMachineManagerImpl.virtualMachineManager();
    }

    protected VirtualMachineManagerImpl() {
        ThreadGroup parent;
        if (TEST) {
            System.err.println("Initializing JB VirtualMachineManager");
        }
        ThreadGroup top = Thread.currentThread().getThreadGroup();
        while ((parent = top.getParent()) != null) {
            top = parent;
        }
        this.mainGroupForJDI = new ThreadGroup(top, "JDI main");
        this.addConnector(new SunCommandLineLauncher());
        this.addConnector(new RawCommandLineLauncher());
        this.addConnector(new SocketAttachingConnector());
        this.addConnector(new SocketListeningConnector());
        this.addConnector(new ProcessAttachingConnector());
        if (VirtualMachineManagerImpl.isWindows()) {
            try {
                this.addConnector(new SharedMemoryListeningConnector());
                this.addConnector(new SharedMemoryAttachingConnector());
            }
            catch (ReflectiveOperationException | InaccessibleObjectException x) {
                x.printStackTrace();
            }
        }
        boolean found = false;
        List<LaunchingConnector> launchers = this.launchingConnectors();
        for (LaunchingConnector lc : launchers) {
            if (!lc.name().equals(VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.CommandLineLaunch"))) continue;
            this.setDefaultConnector(lc);
            found = true;
            break;
        }
        if (!found && launchers.size() > 0) {
            this.setDefaultConnector(launchers.get(0));
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
    }

    @Override
    public LaunchingConnector defaultConnector() {
        if (this.defaultConnector == null) {
            throw new Error("no default LaunchingConnector");
        }
        return this.defaultConnector;
    }

    @Override
    public void setDefaultConnector(LaunchingConnector connector) {
        this.defaultConnector = connector;
    }

    @Override
    public List<LaunchingConnector> launchingConnectors() {
        return this.connectors.stream().filter(connector -> connector instanceof LaunchingConnector).map(connector -> (LaunchingConnector)connector).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<AttachingConnector> attachingConnectors() {
        return this.connectors.stream().filter(connector -> connector instanceof AttachingConnector).map(connector -> (AttachingConnector)connector).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<ListeningConnector> listeningConnectors() {
        return this.connectors.stream().filter(connector -> connector instanceof ListeningConnector).map(connector -> (ListeningConnector)connector).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<Connector> allConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public List<VirtualMachine> connectedVirtualMachines() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    @Override
    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    @Override
    public synchronized VirtualMachine createVirtualMachine(Connection connection, Process process) throws IOException {
        VirtualMachineImpl vm;
        if (!connection.isOpen()) {
            throw new IllegalStateException("connection is not open");
        }
        if (TEST) {
            System.err.println("Creating JB VirtualMachine");
        }
        try {
            vm = new VirtualMachineImpl(this, connection, process, ++this.vmSequenceNumber);
        }
        catch (VMDisconnectedException e2) {
            throw new IOException(e2);
        }
        this.targets.add(vm);
        return vm;
    }

    @Override
    public VirtualMachine createVirtualMachine(Connection connection) throws IOException {
        return this.createVirtualMachine(connection, null);
    }

    public void addVirtualMachine(VirtualMachine vm) {
        this.targets.add(vm);
    }

    void disposeVirtualMachine(VirtualMachine vm) {
        this.targets.remove(vm);
    }

    @Override
    public int majorInterfaceVersion() {
        return 9;
    }

    @Override
    public int minorInterfaceVersion() {
        return 0;
    }

    ThreadGroup mainGroupForJDI() {
        return this.mainGroupForJDI;
    }

    String getString(String key) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.jetbrains.jdi.resources.jdi");
        }
        return this.messages.getString(key);
    }

    static String connectorName(String name) {
        return TEST ? name.replace("jetbrains", "sun") : name;
    }
}

