/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.PlatformConflictDeclarationsDiagnosticDispatcher;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0011H\u0002Jq\u0010\u0012\u001a\u00020\u00072 \u0010\u0013\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00160\u00142 \u0010\u0017\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00160\u00142\u0006\u0010\u0018\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J3\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150$H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010%R\u001c\u0010\u001e\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "getDestructuredParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "declarationShadowedViaContextParameters", "container", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/Map;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isExpectAndNonExpect", "", "first", "second", "isPrimaryConstructor", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,207:1\n865#2,2:208\n774#2:210\n865#2,2:211\n1634#2,3:213\n1625#2:216\n1869#2:217\n1870#2:220\n1626#2:221\n1740#2,3:223\n1#3:218\n1#3:219\n216#4:222\n217#4:226\n216#4,2:227\n18#5:229\n19#5:233\n20#5,2:238\n382#6,3:230\n385#6,4:234\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n90#1:208,2\n96#1:210\n96#1:211,2\n97#1:213,3\n99#1:216\n99#1:217\n99#1:220\n99#1:221\n132#1:223,3\n99#1:219\n116#1:222\n116#1:226\n149#1:227,2\n177#1:229\n177#1:233\n177#1:238,2\n177#1:230,3\n177#1:234,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile(context2, (FirFile)declaration, inspector);
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), (Map)inspector.getDeclarationShadowedViaContextParameters(), declaration);
        } else if (firDeclaration instanceof FirClass) {
            KtSourceElement ktSourceElement = ((FirClass)declaration).getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(context2, reporter, ((FirClass)declaration).getTypeParameters());
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirClass)declaration).getSymbol());
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), (Map)inspector.getDeclarationShadowedViaContextParameters(), declaration);
        } else {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration instanceof FirTypeParameterRefsOwner) {
                if (declaration instanceof FirFunction || declaration instanceof FirProperty) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirCallableDeclaration)declaration);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(context2, reporter, destructuredParameters);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(context2, reporter, ((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirCallableDeclaration declaration) {
        List list;
        block10: {
            void $this$filterTo$iv;
            List $this$getDestructuredParameters_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable iterable = declaration.getContextParameters();
            Iterable destination$iv = $this$getDestructuredParameters_u24lambda_u240;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl2 = false;
                if (!(it.getValueParameterKind() == FirValueParameterKind.ContextParameter)) continue;
                destination$iv.add(element$iv);
            }
            if (declaration instanceof FirFunction) {
                void destination$iv2;
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$getDestructuredParameters_u24lambda_u240.addAll(((FirFunction)declaration).getValueParameters());
                destination$iv = ((FirFunction)declaration).getValueParameters();
                boolean $i$f$filter22 = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getName(), SpecialNames.DESTRUCT)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection $i$f$filter22 = new LinkedHashSet();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirValueParameter bl2 = (FirValueParameter)item$iv;
                    void var15_30 = destination$iv2;
                    boolean bl4 = false;
                    var15_30.add(it.getSymbol());
                }
                Set destructuredParametersBoxes = (Set)destination$iv2;
                Object object = ((FirFunction)declaration).getBody();
                if (object != null && (object = ((FirBlock)object).getStatements()) != null) {
                    void $this$mapNotNullTo$iv;
                    Iterable $i$f$mapTo2 = (Iterable)object;
                    Collection destination$iv3 = $this$getDestructuredParameters_u24lambda_u240;
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        FirVariable firVariable;
                        Object element$iv$iv;
                        Object element$iv = element$iv$iv = iterator3.next();
                        boolean bl5 = false;
                        FirStatement it = (FirStatement)element$iv;
                        boolean bl6 = false;
                        FirVariable firVariable2 = it instanceof FirVariable ? (FirVariable)it : null;
                        if (firVariable2 != null) {
                            FirVariable firVariable3;
                            FirVariable it2 = firVariable3 = firVariable2;
                            boolean bl7 = false;
                            firVariable = CollectionsKt.contains(destructuredParametersBoxes, FirDeclarationUtilKt.getDestructuredParameter(it2)) ? firVariable3 : null;
                        } else {
                            firVariable = null;
                        }
                        if (firVariable == null) continue;
                        FirVariable it$iv = firVariable;
                        boolean bl8 = false;
                        destination$iv3.add(it$iv);
                    }
                    List cfr_ignored_0 = (List)destination$iv3;
                }
            }
            if (!(declaration instanceof FirProperty)) break block10;
            Object object = ((FirProperty)declaration).getSetter();
            if (object != null) {
                FirPropertyAccessor firPropertyAccessor;
                FirPropertyAccessor it = firPropertyAccessor = object;
                boolean bl9 = false;
                KtSourceElement ktSourceElement = it.getSource();
                object = !Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DefaultAccessor.INSTANCE) ? firPropertyAccessor : null;
                if (object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null) {
                    Object it3 = object;
                    boolean bl10 = false;
                    $this$getDestructuredParameters_u24lambda_u240.addAll((Collection)it3);
                }
            }
        }
        return CollectionsKt.build(list);
    }

    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context2, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationShadowedViaContextParameters, FirDeclaration container) {
        SmartSet<FirBasedSymbol<?>> symbols;
        FirBasedSymbol<?> conflictingDeclaration;
        Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> entry;
        Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> element$iv;
        Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> $this$forEach$iv = declarationConflictingSymbols;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PlatformConflictDeclarationsDiagnosticDispatcher dispatcher;
            KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> factory;
            boolean bl;
            KtSourceElement source;
            KtSourceElement ktSourceElement;
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            conflictingDeclaration = entry.getKey();
            symbols = entry.getValue();
            Object object = conflictingDeclaration instanceof FirConstructorSymbol ? (FirConstructorSymbol)conflictingDeclaration : null;
            KtSourceElement typeAliasForConstructorSource = object != null && (object = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo((FirConstructorSymbol)object)) != null && (object = ((TypeAliasConstructorInfo)object).getTypeAliasSymbol()) != null ? ((FirBasedSymbol)object).getSource() : null;
            FirDeclarationOrigin origin = conflictingDeclaration.getOrigin();
            if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else if (Intrinsics.areEqual(origin, FirDeclarationOrigin.Source.INSTANCE)) {
                ktSourceElement = ((FirCallableSymbol)conflictingDeclaration).getSource();
            } else {
                if (Intrinsics.areEqual(origin, FirDeclarationOrigin.Library.INSTANCE)) continue;
                ktSourceElement = source = Intrinsics.areEqual(origin, FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) ? typeAliasForConstructorSource : container.getSource();
            }
            if (symbols.isEmpty()) continue;
            if (INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                boolean bl3;
                block14: {
                    Iterable $this$all$iv = symbols;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv2;
                            boolean bl4 = false;
                            if (INSTANCE.isPrimaryConstructor(it)) continue;
                            bl3 = false;
                            break block14;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) continue;
            }
            if ((FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)symbols) != null) {
                FirBasedSymbol it;
                boolean bl5 = false;
                bl = INSTANCE.isExpectAndNonExpect(conflictingDeclaration, it);
            } else {
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), conflictingDeclaration, null, 16, null);
                continue;
            }
            PlatformConflictDeclarationsDiagnosticDispatcher platformConflictDeclarationsDiagnosticDispatcher = FirConflictsDeclarationCheckerKt.getConflictDeclarationsDiagnosticDispatcher(context2.getSession());
            if (platformConflictDeclarationsDiagnosticDispatcher == null) {
                platformConflictDeclarationsDiagnosticDispatcher = PlatformConflictDeclarationsDiagnosticDispatcher.DEFAULT.INSTANCE;
            }
            if ((factory = (dispatcher = platformConflictDeclarationsDiagnosticDispatcher).getDiagnostic(context2, conflictingDeclaration, symbols)) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, factory, symbols, null, 16, null);
        }
        $this$forEach$iv = declarationShadowedViaContextParameters;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            conflictingDeclaration = entry.getKey();
            symbols = entry.getValue();
            if (!(!((Collection)symbols).isEmpty())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)conflictingDeclaration.getSource(), FirErrors.INSTANCE.getCONTEXTUAL_OVERLOAD_SHADOWED(), symbols, null, 16, null);
        }
    }

    private final boolean isExpectAndNonExpect(FirBasedSymbol<?> first, FirBasedSymbol<?> second) {
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = FirConflictsHelpersKt.getResolvedStatus(first);
        boolean firstIsExpect = firResolvedDeclarationStatus != null ? firResolvedDeclarationStatus.isExpect() : false;
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = FirConflictsHelpersKt.getResolvedStatus(second);
        boolean secondIsExpect = firResolvedDeclarationStatus2 != null ? firResolvedDeclarationStatus2.isExpect() : false;
        return firstIsExpect ^ secondIsExpect;
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual($this$isPrimaryConstructor.getOrigin(), FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(CheckerContext context2, FirFile file, FirDeclarationCollector<FirBasedSymbol<?>> inspector) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv$iv;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        Pair<FqName, FirSession> pair = TuplesKt.to(UtilsKt.getPackageFqName(file), context2.getSession());
        ScopeSessionKey<Pair<FqName, FirSession>, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map map = this_$iv.scopes();
        ScopeSessionKey<Pair<FqName, FirSession>, FirPackageMemberScope> key$iv$iv = id$iv;
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        key$iv$iv = key$iv;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file, packageMemberScope);
    }
}

