/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bH\u0002\u00a8\u0006\t"}, d2={"isValidSingleQuotedStringContent", "", "text", "", "isValidDoubleQuotedStringContent", "isValidContent", "escapedChars", "", "", "intellij.groovy.psi"})
public final class StringUtilKt {
    public static final boolean isValidSingleQuotedStringContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char[] cArray = new char[]{'\'', '\n'};
        return StringUtilKt.isValidContent(text, cArray);
    }

    public static final boolean isValidDoubleQuotedStringContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char[] cArray = new char[]{'\"', '$', '\n'};
        return StringUtilKt.isValidContent(text, cArray);
    }

    private static final boolean isValidContent(String text, char ... escapedChars) {
        int length = text.length();
        int idx = 0;
        while (idx < length) {
            char nextCh;
            char ch = text.charAt(idx);
            if (ArraysKt.contains((char[])escapedChars, (char)ch)) {
                return false;
            }
            if (ch == '\\' && idx + 1 < length && ((nextCh = text.charAt(idx + 1)) == '\\' || ArraysKt.contains((char[])escapedChars, (char)nextCh))) {
                idx += 2;
                continue;
            }
            ++idx;
        }
        return true;
    }
}

