/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationAwareInjector;
import org.intellij.plugins.intelliLang.inject.groovy.GrInjectionUtil;
import org.intellij.plugins.intelliLang.inject.java.JavaLanguageInjectionSupport;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;

final class GroovyLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    public static final String GROOVY_SUPPORT_ID = "groovy";

    GroovyLanguageInjectionSupport() {
    }

    @NotNull
    public String getId() {
        return GROOVY_SUPPORT_ID;
    }

    public Class @NotNull [] getPatternClasses() {
        Class[] classArray = new Class[]{GroovyPatterns.class};
        if (classArray == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<? super PsiElement> commentRef) {
        PsiFile containingFile;
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        boolean compiled = (containingFile = host.getContainingFile()) != null && containingFile.getOriginalFile() instanceof PsiCompiledFile;
        return compiled ? null : super.findCommentInjection(host, commentRef);
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof GroovyPsiElement;
    }

    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return true;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.groovy";
    }

    public boolean addInjectionInPlace(Language language, @Nullable PsiLanguageInjectionHost psiElement) {
        if (language == null) {
            return false;
        }
        if (!GroovyLanguageInjectionSupport.isStringLiteral(psiElement)) {
            return false;
        }
        return GroovyLanguageInjectionSupport.doInject(language.getID(), (PsiElement)psiElement, psiElement);
    }

    public boolean removeInjectionInPlace(@Nullable PsiLanguageInjectionHost psiElement) {
        if (!GroovyLanguageInjectionSupport.isStringLiteral(psiElement)) {
            return false;
        }
        GrLiteralContainer host = (GrLiteralContainer)psiElement;
        HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap = new HashMap<BaseInjection, Pair<PsiMethod, Integer>>();
        ArrayList<PsiElement> annotations = new ArrayList<PsiElement>();
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        GroovyLanguageInjectionSupport.collectInjections(host, configuration, (LanguageInjectionSupport)this, injectionsMap, annotations);
        if (injectionsMap.isEmpty() && annotations.isEmpty()) {
            return false;
        }
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>(injectionsMap.keySet());
        List newInjections = ContainerUtil.mapNotNull(originalInjections, (Function)((NullableFunction)injection -> {
            Pair pair = (Pair)injectionsMap.get(injection);
            String placeText = JavaLanguageInjectionSupport.getPatternStringForJavaPlace((PsiMethod)((PsiMethod)pair.first), (int)((Integer)pair.second));
            BaseInjection newInjection = injection.copy();
            newInjection.setPlaceEnabled(placeText, false);
            return InjectorUtils.canBeRemoved((BaseInjection)newInjection) ? null : newInjection;
        }));
        configuration.replaceInjectionsWithUndo(project, psiElement.getContainingFile(), newInjections, originalInjections, annotations);
        return true;
    }

    private static void collectInjections(@NotNull GrLiteralContainer host, @NotNull Configuration configuration, @NotNull LanguageInjectionSupport support, final @NotNull HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap, final @NotNull ArrayList<PsiElement> annotations) {
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(3);
        }
        if (support == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(4);
        }
        if (injectionsMap == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(5);
        }
        if (annotations == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(6);
        }
        new GrConcatenationAwareInjector.InjectionProcessor(configuration, support, new PsiElement[]{host}){

            @Override
            protected boolean processCommentInjectionInner(PsiVariable owner, PsiElement comment, BaseInjection injection) {
                ContainerUtil.addAll((Collection)annotations, (Object[])new PsiElement[]{comment});
                return true;
            }

            @Override
            protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annos) {
                ContainerUtil.addAll((Collection)annotations, (Object[])annos);
                return true;
            }

            @Override
            protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
                injectionsMap.put(injection, Pair.create((Object)method, (Object)paramIndex));
                return true;
            }
        }.processInjections();
    }

    private static boolean doInject(@NotNull String languageId, @NotNull PsiElement psiElement, @NotNull PsiLanguageInjectionHost host) {
        if (languageId == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(7);
        }
        if (psiElement == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(8);
        }
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(9);
        }
        PsiElement target = GroovyLanguageInjectionSupport.getTopLevelInjectionTarget(psiElement);
        PsiElement parent = target.getParent();
        Project project = psiElement.getProject();
        if (parent instanceof GrReturnStatement) {
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(parent);
            if (owner instanceof GrOpenBlock && owner.getParent() instanceof GrMethod) {
                return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((PsiMethod)owner.getParent()), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
            }
        } else {
            Processor<PsiLanguageInjectionHost> fixer;
            if (parent instanceof GrMethod) {
                return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((GrMethod)parent), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
            }
            if (parent instanceof GrAnnotationNameValuePair) {
                PsiElement resolved;
                PsiReference ref2 = parent.getReference();
                if (ref2 != null && (resolved = ref2.resolve()) instanceof PsiMethod) {
                    return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((PsiMethod)resolved), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
                }
            } else if (parent instanceof GrArgumentList && parent.getParent() instanceof GrMethodCall) {
                int index;
                PsiMethod method = ((GrMethodCall)parent.getParent()).resolveMethod();
                if (method != null && (index = GrInjectionUtil.findParameterIndex(target, (GrMethodCall)parent.getParent())) >= 0) {
                    return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)method, (int)index, (PsiLanguageInjectionHost)host, (String)languageId);
                }
            } else if (parent instanceof GrAssignmentExpression) {
                PsiElement element;
                GrExpression expr = ((GrAssignmentExpression)parent).getLValue();
                if (expr instanceof GrReferenceExpression && (element = ((GrReferenceExpression)expr).resolve()) != null) {
                    return GroovyLanguageInjectionSupport.doInject(languageId, element, host);
                }
            } else if (parent instanceof PsiVariable ? JavaLanguageInjectionSupport.doAddLanguageAnnotation((Project)project, (PsiModifierListOwner)((PsiModifierListOwner)parent), (PsiLanguageInjectionHost)host, (String)languageId, fixer = GroovyLanguageInjectionSupport.getAnnotationFixer(project, languageId)) : target instanceof PsiVariable && !(target instanceof LightElement) && JavaLanguageInjectionSupport.doAddLanguageAnnotation((Project)project, (PsiModifierListOwner)((PsiModifierListOwner)target), (PsiLanguageInjectionHost)host, (String)languageId, fixer = GroovyLanguageInjectionSupport.getAnnotationFixer(project, languageId))) {
                return true;
            }
        }
        return false;
    }

    private static Processor<PsiLanguageInjectionHost> getAnnotationFixer(@NotNull Project project, @NotNull String languageId) {
        if (project == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(10);
        }
        if (languageId == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(11);
        }
        return host -> {
            if (host == null) {
                return false;
            }
            Configuration.AdvancedConfiguration configuration = Configuration.getProjectInstance((Project)project).getAdvancedConfiguration();
            boolean allowed = configuration.isSourceModificationAllowed();
            configuration.setSourceModificationAllowed(true);
            try {
                boolean bl = GroovyLanguageInjectionSupport.doInject(languageId, (PsiElement)host, host);
                return bl;
            }
            finally {
                configuration.setSourceModificationAllowed(allowed);
            }
        };
    }

    @Contract(value="null -> false")
    private static boolean isStringLiteral(@Nullable PsiLanguageInjectionHost element) {
        if (element instanceof GrStringContent) {
            return true;
        }
        if (element instanceof GrLiteral) {
            IElementType type = GrLiteralImpl.getLiteralType((GrLiteral)element);
            return TokenSets.STRING_LITERALS.contains(type);
        }
        return false;
    }

    @NotNull
    public static PsiElement getTopLevelInjectionTarget(@NotNull PsiElement host) {
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(12);
        }
        PsiElement target = host;
        PsiElement parent = target.getParent();
        while (parent != null) {
            if (!(parent instanceof GrBinaryExpression || parent instanceof GrString || parent instanceof GrParenthesizedExpression || parent instanceof GrConditionalExpression && ((GrConditionalExpression)parent).getCondition() != target || parent instanceof GrAnnotationArrayInitializer)) {
                if (!(parent instanceof GrListOrMap)) break;
                parent = parent.getParent();
            }
            target = parent;
            parent = target.getParent();
        }
        PsiElement psiElement = target;
        if (psiElement == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/groovy/GroovyLanguageInjectionSupport";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionsMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/groovy/GroovyLanguageInjectionSupport";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelInjectionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectInjections";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doInject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationFixer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelInjectionTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

