/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns.standard;

import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.LambdaMatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.nlp.utils.normalization.UnicodePunctuationNormalizer;
import ai.grazie.text.TextRange;
import ai.grazie.utils.mpp.TextRegex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u001f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u0010\u0003R\u0010\u00108\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lai/grazie/nlp/patterns/standard/LikelyPatterns;", "", "<init>", "()V", "AcademicCitation", "Lai/grazie/nlp/patterns/Pattern;", "IsEmail", "CommandLineOption", "PythonString", "ChainedName", "FunctionName", "PropertyName", "snakeKebabName", "minSeparatorCount", "", "IsMention", "ChatTextEmoji", "IsEncodedBinary", "Lai/grazie/nlp/patterns/LambdaMatchPattern;", "IsIPv4", "IsFilePath", "IsURL", "DataUrlBase64", "IsAbbreviation", "romanDigits", "", "LongRomanNumeral", "deBeforeNumerals", "startsWithLowerCase", "", "text", "", "IsGermanOrdinal", "IsGermanDateWithDot", "IsGermanOrdinalAfterNames", "IsCompositeInflection", "russianExtendedInitial", "germanExtendedInitial", "initial", "firstNameInitials", "onlyInitials", "lastNameInitial", "NameInitials", "looksLikeNonBullet", "smileyStartChars", "smileyPattern", "dashLikeChars", "PunctuationOperator", "TicketName", "Chemical", "IsIBAN", "IsHashLike", "LicenseKey", "DatePattern", "RestoredWordPart", "getRestoredWordPart$annotations", "IsRebusAbbreviation", "IsExcelFormula", "quotes", "IsDotInBashCommand", "IsInnerSentenceInQuotes", "IsGermanStreetName", "nlp-patterns"})
@SourceDebugExtension(value={"SMAP\nLikelyPatterns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LikelyPatterns.kt\nai/grazie/nlp/patterns/standard/LikelyPatterns\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,524:1\n1069#2,2:525\n1088#2,2:527\n*S KotlinDebug\n*F\n+ 1 LikelyPatterns.kt\nai/grazie/nlp/patterns/standard/LikelyPatterns\n*L\n114#1:525,2\n114#1:527,2\n*E\n"})
public final class LikelyPatterns {
    @NotNull
    public static final LikelyPatterns INSTANCE;
    @JvmField
    @NotNull
    public static final Pattern AcademicCitation;
    @JvmField
    @NotNull
    public static final Pattern IsEmail;
    @JvmField
    @NotNull
    public static final Pattern CommandLineOption;
    @JvmField
    @NotNull
    public static final Pattern PythonString;
    @JvmField
    @NotNull
    public static final Pattern ChainedName;
    @JvmField
    @NotNull
    public static final Pattern FunctionName;
    @JvmField
    @NotNull
    public static final Pattern PropertyName;
    @JvmField
    @NotNull
    public static final Pattern IsMention;
    @JvmField
    @NotNull
    public static final Pattern ChatTextEmoji;
    @JvmField
    @NotNull
    public static final LambdaMatchPattern IsEncodedBinary;
    @JvmField
    @NotNull
    public static final Pattern IsIPv4;
    @JvmField
    @NotNull
    public static final Pattern IsFilePath;
    @JvmField
    @NotNull
    public static final Pattern IsURL;
    @JvmField
    @NotNull
    public static final Pattern DataUrlBase64;
    @JvmField
    @NotNull
    public static final Pattern IsAbbreviation;
    @NotNull
    public static final String romanDigits = "IVXLMCD";
    @JvmField
    @NotNull
    public static final Pattern LongRomanNumeral;
    @NotNull
    private static final String deBeforeNumerals = "rsmneudt";
    @JvmField
    @NotNull
    public static final Pattern IsGermanOrdinal;
    @JvmField
    @NotNull
    public static final Pattern IsGermanDateWithDot;
    @JvmField
    @NotNull
    public static final Pattern IsGermanOrdinalAfterNames;
    @JvmField
    @NotNull
    public static final Pattern IsCompositeInflection;
    @NotNull
    private static final String russianExtendedInitial = "\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432";
    @NotNull
    private static final String germanExtendedInitial = "S(ch|p)";
    @NotNull
    private static final String initial = "(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.";
    @NotNull
    private static final String firstNameInitials = "((\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.\\s?){1,2}([:?!)\u2013\u2014-]|\\p{Lu}\\p{Ll}+)";
    @NotNull
    private static final String onlyInitials = "(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.(\\s?(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.)*";
    @NotNull
    private static final String lastNameInitial = "\\p{Lu}(\\p{Ll})+\\s\\p{Lu}\\.";
    @JvmField
    @NotNull
    public static final Pattern NameInitials;
    @NotNull
    public static final String smileyStartChars = ":;";
    @NotNull
    public static final String smileyPattern = "[:;]-?[()]+";
    @NotNull
    public static final String dashLikeChars = "-\u2013\u2014";
    @JvmField
    @NotNull
    public static final Pattern PunctuationOperator;
    @JvmField
    @NotNull
    public static final Pattern TicketName;
    @JvmField
    @NotNull
    public static final Pattern Chemical;
    @JvmField
    @NotNull
    public static final Pattern IsIBAN;
    @JvmField
    @NotNull
    public static final Pattern IsHashLike;
    @JvmField
    @NotNull
    public static final Pattern LicenseKey;
    @JvmField
    @NotNull
    public static final Pattern DatePattern;
    @JvmField
    @NotNull
    public static final Pattern RestoredWordPart;
    @JvmField
    @NotNull
    public static final Pattern IsRebusAbbreviation;
    @JvmField
    @NotNull
    public static final Pattern IsExcelFormula;
    @NotNull
    private static final String quotes;
    @JvmField
    @NotNull
    public static final Pattern IsDotInBashCommand;
    @JvmField
    @NotNull
    public static final Pattern IsInnerSentenceInQuotes;
    @JvmField
    @NotNull
    public static final Pattern IsGermanStreetName;

    private LikelyPatterns() {
    }

    @NotNull
    public final Pattern snakeKebabName(int minSeparatorCount) {
        String version = "\\d+(.\\d+)*";
        String part = "[a-z]+\\*?";
        String id = part + "([-_]\\*?" + part + "){" + minSeparatorCount + ",}";
        return new RegexPattern(id + "(-?" + version + ")?|" + version + "(-" + part + ")+").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::snakeKebabName$lambda$11));
    }

    private final boolean startsWithLowerCase(CharSequence text2) {
        return text2.length() > 0 && Character.isLowerCase(text2.charAt(0));
    }

    private final boolean looksLikeNonBullet(CharSequence text2) {
        int n;
        int n2;
        CharSequence charSequence;
        return text2.length() >= 3 && (!StringsKt.startsWith$default((CharSequence)text2, (CharSequence)". ", (int)1, (boolean)false, (int)4, null) || StringsKt.contains$default((CharSequence)((Object)(charSequence = text2).subSequence(n2 = 3, n = charSequence.length())).toString(), (CharSequence)". ", (boolean)false, (int)2, null));
    }

    public static /* synthetic */ void getRestoredWordPart$annotations() {
    }

    private static final List AcademicCitation$lambda$3$lambda$2(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List CommandLineOption$lambda$5(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List PythonString$lambda$6(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List ChainedName$lambda$8$lambda$7(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List FunctionName$lambda$9(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List PropertyName$lambda$10(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List snakeKebabName$lambda$11(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List ChatTextEmoji$lambda$13(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean IsEncodedBinary$lambda$17(CharSequence text2) {
        char it;
        char element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence $this$all$iv = text2;
        boolean $i$f$all = false;
        for (n = 0; n < $this$all$iv.length(); ++n) {
            it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (!Character.isUpperCase(it)) {
                if (!Character.isDigit(it)) return false;
            }
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$all$iv = text2;
        $i$f$all = false;
        for (n = 0; n < $this$all$iv.length(); ++n) {
            it = element$iv = $this$all$iv.charAt(n);
            boolean bl3 = false;
            if (Character.isLetterOrDigit(it)) continue;
            return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        CharSequence $this$any$iv = text2;
        boolean $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it = element$iv = $this$any$iv.charAt(n);
            boolean bl5 = false;
            if (Character.isDigit(it)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final List IsIPv4$lambda$18(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List DataUrlBase64$lambda$20(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List LongRomanNumeral$lambda$21(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsGermanDateWithDot$lambda$22(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsGermanOrdinalAfterNames$lambda$23(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List PunctuationOperator$lambda$26$lambda$25(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List TicketName$lambda$27(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List Chemical$lambda$29$lambda$28(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsIBAN$lambda$31$lambda$30(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List RestoredWordPart$lambda$32(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsExcelFormula$lambda$34$lambda$33(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsDotInBashCommand$lambda$35(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsInnerSentenceInQuotes$lambda$36(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    private static final List IsGermanStreetName$lambda$37(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.invoke();
    }

    public static final /* synthetic */ boolean access$startsWithLowerCase(LikelyPatterns $this, CharSequence text2) {
        return $this.startsWithLowerCase(text2);
    }

    public static final /* synthetic */ boolean access$looksLikeNonBullet(LikelyPatterns $this, CharSequence text2) {
        return $this.looksLikeNonBullet(text2);
    }

    static {
        LikelyPatterns $this$AcademicCitation_u24lambda_u243 = INSTANCE = new LikelyPatterns();
        boolean bl = false;
        String year = "(1[89]|20)\\d\\d";
        LikelyPatterns $this$AcademicCitation_u24lambda_u243_u24lambda_u240 = $this$AcademicCitation_u24lambda_u243;
        boolean bl2 = false;
        String surname = "\\p{Lu}\\p{Ll}+";
        String andWord = "and|und|\u0438|\u0442\u0430";
        String etAlWords = "et\\sal\\.|\u0438\\s\u0434\u0440\\.|\u0442\u0430\\s\u0456\u043d\\.";
        String authors = surname + "((\\s?&\\s?|,\\s|/|\\s(" + andWord + ")\\s)" + surname + ")*(\\s(" + etAlWords + ")|,)?";
        String pageOrYear = "[1-9]\\d*";
        String singleRef = authors + ",?\\s" + pageOrYear + "\\p{L}?";
        String moreCitations = "[^\\])]+\\s" + singleRef;
        String citationWithInnerParens = authors + "\\s\\(" + year + "\\p{L}?(" + moreCitations + ")*";
        LikelyPatterns $this$AcademicCitation_u24lambda_u243_u24lambda_u241 = $this$AcademicCitation_u24lambda_u243;
        boolean bl3 = false;
        String cf = "(cf|vgl|\u0441\u0440)\\.\\s";
        String citationInParens = "[(\\[](" + cf + ")?(" + singleRef + "(" + moreCitations + ")*|" + authors + moreCitations + ")";
        AcademicCitation = new RegexPattern(new Regex(citationInParens + "|" + citationWithInnerParens)).withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::AcademicCitation$lambda$3$lambda$2));
        LikelyPatterns $this$IsEmail_u24lambda_u244 = INSTANCE;
        boolean bl4 = false;
        String specialPrefixChars = "_.+-";
        singleRef = new Regex("[a-zA-Z0-9" + specialPrefixChars + "]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+");
        IsEmail = new RegexPattern(specialPrefixChars, (Regex)singleRef){
            final /* synthetic */ String $specialPrefixChars;
            {
                this.$specialPrefixChars = $specialPrefixChars;
                super($super_call_param$1);
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int n = text2.length() - 3;
                for (int i = 1; i < n; ++i) {
                    MatchResult it;
                    if (text2.charAt(i) != '@') continue;
                    int start = 0;
                    start = i;
                    while (start - 1 > 0 && (Character.isLetterOrDigit(text2.charAt(start - 1)) || StringsKt.contains$default((CharSequence)this.$specialPrefixChars, (char)text2.charAt(start - 1), (boolean)false, (int)2, null))) {
                        int n2 = start;
                        start = n2 + -1;
                    }
                    if (start >= i) continue;
                    if (this.getRegex().matchAt(text2, start) == null) continue;
                    boolean bl = false;
                    result2.add(new TextRange(start, it.getRange().getLast() + 1));
                }
                return result2;
            }
        };
        CommandLineOption = new RegexPattern("-(-[a-z0-9][a-z0-9-]+|[a-zA-Z][a-zA-Z0-9.=-]+)").afterReversed(new Regex("$|[\\s\\p{Pi}\\p{Po}(]")).traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::CommandLineOption$lambda$5));
        PythonString = new RegexPattern("f['\"]").afterWordBoundary().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::PythonString$lambda$6));
        LikelyPatterns $this$ChainedName_u24lambda_u248 = INSTANCE;
        boolean bl5 = false;
        String part = "[a-zA-Z_]([a-zA-Z_\\d]*)";
        ChainedName = new RegexPattern(part + "(\\." + part + ")+").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::ChainedName$lambda$8$lambda$7));
        FunctionName = new RegexPattern("\\(\\)").expandBack(new Regex("[a-zA-Z_\\d]+")).withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::FunctionName$lambda$9));
        PropertyName = new RegexPattern("=").expandBack(new Regex("[-_a-z\\d]+")).withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::PropertyName$lambda$10));
        LikelyPatterns $this$IsMention_u24lambda_u2412 = INSTANCE;
        boolean bl6 = false;
        String nickname = "[\\w.]+";
        String fullName = "\\p{Lu}\\p{Ll}+([\\s.]\\p{Lu}\\p{Ll}+)+";
        String personMention = "@(" + fullName + "|" + nickname + ")";
        String hashtag = "#[\\p{L}\\d_]([\\p{L}\\d_-]+)?[\\p{L}\\d_]";
        citationInParens = new Regex(personMention + "|" + hashtag);
        IsMention = new RegexPattern((Regex)citationInParens){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.afterWordBoundary();
        ChatTextEmoji = new RegexPattern(":\\w+:").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::ChatTextEmoji$lambda$13));
        IsEncodedBinary = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)LikelyPatterns::IsEncodedBinary$lambda$17));
        IsIPv4 = new RegexPattern("(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4])").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsIPv4$lambda$18));
        LikelyPatterns $this$IsFilePath_u24lambda_u2419 = INSTANCE;
        boolean bl7 = false;
        String slash = "([/\\\\]{1,2})";
        String forwardSlash = "/{1,2}";
        String namePart = "(\\.?[\\w~-])";
        String basePathPart = namePart + "{1,100}";
        String specialPathPart = "(<(" + namePart + "| ){1,100}>|%(" + namePart + "| ){1,100}%|\\$\\{" + namePart + "{1,100}\\}|\\*+)";
        String pathPart = "(" + basePathPart + "|" + specialPathPart + ")";
        Object uriScheme = "([A-Z]|[a-z]{1,10}):";
        String pathWithSlashes = "(.." + slash + pathPart + "|" + (String)uriScheme + "|" + specialPathPart + ")(" + slash + pathPart + "){1,100}" + slash + "?";
        String pathWithForwardSlashes = "(" + basePathPart + ")?(" + forwardSlash + pathPart + "){1,100}(" + forwardSlash + ")?";
        String dotName = "\\*?\\.[a-z][a-z0-9]{1,6}";
        String nameWithExtensionAndPunctuation = "[a-zA-Z][\\w\\*]+-[-\\w\u2039\u203a<>{}]*\\*?\\.\\*?[a-z]{1,5}";
        String pathWildcard = "<" + namePart + "{1,100}?_" + namePart + "{1,100}>";
        Regex regex = new Regex(pathWithSlashes + "|" + pathWithForwardSlashes + "|" + nameWithExtensionAndPunctuation + "|" + pathWildcard + "|" + dotName);
        IsFilePath = new RegexPattern(regex){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isNamePatternPart(char c) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                if (StringsKt.contains$default((CharSequence)"~_-\u2039\u203a<>{}*", (char)c, (boolean)false, (int)2, null)) return true;
                if ('0' <= c) {
                    if (c < ':') {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) return true;
                if ('a' <= c) {
                    if (c < '{') {
                        return true;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) return true;
                if ('A' <= c) {
                    if (c < '[') {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) return true;
                if (c != ':') return false;
                return true;
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int minStart = 0;
                block0: for (int i = 0; i < text2.length(); ++i) {
                    int start;
                    boolean retreat;
                    char c = text2.charAt(i);
                    boolean bl = retreat = c == '/' || c == '\\' || c == '<' || c == '.';
                    if (!retreat && c != '%' && c != '$') continue;
                    if (retreat) {
                        for (start = i; start > minStart && this.isNamePatternPart(text2.charAt(start - 1)); --start) {
                        }
                    }
                    while (start <= i) {
                        MatchResult match;
                        if (this.isPathStartAllowed(text2, start) && (match = this.getRegex().matchAt(text2, start)) != null) {
                            minStart = match.getRange().getLast() + 1;
                            result2.add(TextRange.Companion.invoke(match.getRange()));
                            i = Math.max(match.getRange().getLast(), i);
                            continue block0;
                        }
                        ++start;
                    }
                }
                return result2;
            }

            private final boolean isPathStartAllowed(CharSequence text2, int start) {
                return !(!Pattern.Companion.isWordBoundaryBefore(text2, start) || start > 0 && text2.charAt(start - 1) == '<' || start > 0 && Character.isLetterOrDigit(text2.charAt(start - 1)));
            }
        }.beforeWordBoundary();
        IsURL = new Pattern(){
            private final Regex optionalPrefixRegex;
            private final Regex mainUrlPartsRegex;
            {
                this.optionalPrefixRegex = new Regex("(?:[-\\w+.]{2,}://)?(?:\\S+(?::\\S+)?@)?");
                this.mainUrlPartsRegex = new Regex("(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4])|(?:(?:[\\p{L}\\d][\\p{L}\\d_-]{0,62})?[\\p{L}\\d]\\.)+(?:\\p{L}\\p{Ll}{1,20}|\\p{Lu}{2,4}))(?::\\d{2,5})?(?:[/?#]\\S*)?");
            }

            private final boolean isMainUrlPart(char c) {
                return c == '_' || c == '-' || Character.isLetterOrDigit(c);
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int i = 1;
                while (i < text2.length() - 1) {
                    if (text2.charAt(i) == '.' && this.isMainUrlPart(text2.charAt(i - 1)) && this.isMainUrlPart(text2.charAt(i + 1))) {
                        TextRange range;
                        MatchResult mainMatch;
                        int mainStart;
                        for (mainStart = i - 1; mainStart > 0 && this.isMainUrlPart(text2.charAt(mainStart - 1)); --mainStart) {
                        }
                        while (i < text2.length() && !CharsKt.isWhitespace((char)text2.charAt(i))) {
                            ++i;
                        }
                        MatchResult matchResult = this.mainUrlPartsRegex.matchAt(text2, mainStart);
                        if (matchResult == null || (matchResult = matchResult.getRange()) == null || (mainMatch = matchResult).getLast() + 1 < text2.length() && this.isMainUrlPart(text2.charAt(mainMatch.getLast() + 1)) || this.addPrefixes(TextRange.Companion.invoke((IntRange)mainMatch), text2) == null) continue;
                        result2.add(range);
                        continue;
                    }
                    ++i;
                }
                return result2;
            }

            private final TextRange addPrefixes(TextRange range, CharSequence text2) {
                int start;
                if (range.getStart() > 2 && (text2.charAt(start = range.getStart() - 1) == '@' || text2.charAt(start) == '/')) {
                    while (start > 0 && !CharsKt.isWhitespace((char)text2.charAt(start - 1))) {
                        --start;
                    }
                    while (start < range.getStart() - 1) {
                        if (Pattern.Companion.isWordBoundaryBefore(text2, start) && this.optionalPrefixRegex.matches(text2.subSequence(start, range.getStart()))) {
                            return new TextRange(start, range.getEndExclusive());
                        }
                        ++start;
                    }
                    return null;
                }
                return range;
            }

            public boolean matches(CharSequence text2) {
                MatchResult prefix;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                int dot = StringsKt.indexOf$default((CharSequence)text2, (char)'.', (int)1, (boolean)false, (int)4, null);
                if (dot < 0 || dot >= text2.length() - 2 || !this.isMainUrlPart(text2.charAt(dot - 1)) || !this.isMainUrlPart(text2.charAt(dot + 1))) {
                    return false;
                }
                MatchResult matchResult = prefix = this.optionalPrefixRegex.matchAt(text2, 0);
                return this.mainUrlPartsRegex.matchesAt(text2, matchResult == null ? 0 : matchResult.getRange().getLast() + 1);
            }
        }.exclude(IsIPv4).exclude(IsEmail);
        DataUrlBase64 = new RegexPattern("data:\\S*?(;base64),\\S+").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::DataUrlBase64$lambda$20));
        IsAbbreviation = AbbreviationPatterns.All;
        LongRomanNumeral = new RegexPattern("[IVXLMCD]{6,15}").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::LongRomanNumeral$lambda$21));
        Regex regex2 = new Regex("(\\d{1,3})\\.");
        RegexPattern regexPattern = new RegexPattern(regex2){
            private final Regex definiteContinuation;
            {
                this.definiteContinuation = new Regex(" ((" + CollectionsKt.joinToString$default((Iterable)AbbreviationPatterns.INSTANCE.getGermanMonthsShort(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")\\.|" + CollectionsKt.joinToString$default((Iterable)AbbreviationPatterns.INSTANCE.getGermanMonthsFull(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")");
            }

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange range = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!(range.getStart() > 0 || this.definiteContinuation.matchesAt(text2, range.getEndExclusive()) || LikelyPatterns.access$startsWithLowerCase(LikelyPatterns.INSTANCE, StringsKt.trim((CharSequence)text2.subSequence(range.getEndExclusive(), text2.length()))))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        };
        String string = deBeforeNumerals.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        IsGermanOrdinal = regexPattern.afterReversed(new Regex("$|[ \\t]+(,?[,.rsmneudt" + string + "]|" + TextRegex.INSTANCE.getPunctuation().getPattern() + ")")).before(new Regex("[ \u00a0]([a-z\u00e4\u00f6\u00fcA-Z\u00c4\u00d6\u00dc]\\p{L}*|bis|zu|an|und|oder|od\\.)"));
        IsGermanDateWithDot = new RegexPattern("(0?\\d|[12]\\d|3[01])\\.(0?\\d|1[012])\\.").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsGermanDateWithDot$lambda$22));
        String string2 = romanDigits.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        IsGermanOrdinalAfterNames = new RegexPattern("[IVXLMCD" + string2 + "]+\\.").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsGermanOrdinalAfterNames$lambda$23));
        LikelyPatterns $this$IsCompositeInflection_u24lambda_u2424 = INSTANCE;
        boolean bl8 = false;
        String russianAdjEndings = "([\u044b\u0438\u043e\u0435]?\u0439|[\u0430\u044c]?\u044f|[\u043e\u044c\u044b]?\u0435|\u044c?\u0438|([\u043e\u0435]?\u0433)?\u043e|([\u044b\u043e\u0435\u0438]?\u043c)?\u0443|[\u044c\u0443]?\u044e|[\u044b\u0438]?\u0445|(\u044b\u0438)?\u043c\u0438?)";
        String ukrainianAdjEndings = "(\u0456([\u0439\u043c\u0445]|\u043c\u0438)|[\u0430\u0443\u0435\u0456\u044f\u0454\u044e]|\u043e?(\u0433\u043e|\u043c\u0443|\u0457)|\u0438?([\u0439\u043c\u0445]|\u043c\u0438)|\u044c\u043e(\u0433\u043e|\u043c\u0443|\u0457))";
        String latinLikeWord = "[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00dfs0-9]+";
        basePathPart = new Regex("(\u0449\u0438)?[\u0430-\u044f\u0451\u0457\u0456\u0454\u0491]{1,5}|ing|ed");
        Pattern latinWithEnding2 = new RegexPattern((Regex)basePathPart){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.beforeWordBoundary().afterReversed(new Regex("[-']" + latinLikeWord + "|[A-Z\u00c4\u00d6\u00dc]([a-z\u00e4\u00f6\u00fc]+[A-Z\u00c4\u00d6\u00dc]{2}|[A-Z\u00c4\u00d6\u00dc])"));
        pathPart = new Regex("\\p{Lu}\\p{L}+\u0432\\(\u0432(\u0430|\u043e\u0439|\u0443|\u044b|\u044b\u043c\u0438?|\u044b\u0445)\\)");
        RegexPattern parenthesizedSurnameEnding2 = new RegexPattern((Regex)pathPart){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        uriScheme = "/" + russianAdjEndings;
        Pattern slashEnding2 = new RegexPattern((String)uriScheme){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.expandBack(new Regex("[\u0430-\u044f\u0451\u0410-\u042f\u0401]+"));
        Pattern wordWithOptionalEnding2 = new RegexPattern(){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.afterReversed(new Regex("\\p{L}+"));
        pathWithSlashes = new Pattern[]{new RegexPattern("nnen").expandBack(new Regex("(I|i[*:])\\p{Ll}+\\p{Lu}")), new RegexPattern("(e[RN]|E[RN]?)").beforeWordBoundary().expandBack(new Regex("\\p{Ll}\\p{L}{2,}"))};
        pathWithForwardSlashes = pathWithSlashes;
        AggregatedPattern germanGendern2 = new AggregatedPattern((Pattern[])pathWithForwardSlashes){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        pathWithSlashes = "[_:*/]([\u0432\u0440\u0442\u043c]?" + russianAdjEndings + "|((\u043d\u0438)?[\u043a\u0446])?([\u0430\u0438\u044b\u0435\u0443]|\u043e\u0439|\u0435\u0439|\u0430\u043c\u0438?|\u0430\u0445)|\u043e?\u043a|\u0438?\u0446|\\p{L}?([\u0430\u0443\u0435\u044b\u044f\u044e\u0438]|\u043e\u043c|\u0435\u043c|\u0451\u043c|\u0430\u043c\u0438?|\u044f\u043c\u0438?|\u0430\u0445|\u044f\u0445|\u043e\u0432|\u0435\u0432))";
        Pattern russianGender2 = new RegexPattern(pathWithSlashes){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.expandBack(new Regex("\\p{L}{3,}"));
        Pattern russianNumeralOrEnding = new RegexPattern(new Regex("(\\d+%?|%|-)(\u043e\u0432|\u043e\u043c|[\u0432\u0440\u0442\u043c\u043d]?" + russianAdjEndings + "|\u0430\u043c\u0438?|\u0430\u0445|[\u0430\u0443\u0435\u044b])")).beforeWordBoundary();
        Pattern ukrainianNumeralOrEnding = new RegexPattern(new Regex("(\\d+%?|%)?-[\u0448\u0433\u0442\u043c\u0432\u043d]?" + ukrainianAdjEndings)).beforeWordBoundary();
        RegexPattern englishNumeralEnding = new RegexPattern(new Regex("\\d+(st|nd|rd|th|ers?)"));
        Pattern germanNumeralEnding = new RegexPattern(new Regex("\\d((s?t)?e(rn?|[mns]?)|%-?ig(e[rmns]?)?)")).beforeWordBoundary();
        Pattern latinSuffix = new RegexPattern(new Regex("[-']itis")).beforeWordBoundary().afterReversed(new Regex(latinLikeWord));
        Pattern[] patternArray = new Pattern[6];
        Pattern[] patternArray2 = new Pattern[]{parenthesizedSurnameEnding2, slashEnding2, wordWithOptionalEnding2, germanGendern2, russianGender2, englishNumeralEnding};
        patternArray[0] = new AggregatedPattern(patternArray2).withWordBoundariesAround();
        patternArray[1] = russianNumeralOrEnding;
        patternArray[2] = ukrainianNumeralOrEnding;
        patternArray[3] = germanNumeralEnding;
        patternArray[4] = latinWithEnding2;
        patternArray[5] = latinSuffix;
        Pattern[] patternArray3 = patternArray;
        IsCompositeInflection = new AggregatedPattern(patternArray3){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        regex2 = new Regex("((\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.\\s?){1,2}([:?!)\u2013\u2014-]|\\p{Lu}\\p{Ll}+)|\\p{Lu}(\\p{Ll})+\\s\\p{Lu}\\.|(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.(\\s?(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432|S(ch|p))\\.)*");
        NameInitials = new RegexPattern(regex2){

            public List<TextRange> find(CharSequence text2) {
                TextRange it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getStart() > 0 || LikelyPatterns.access$looksLikeNonBullet(LikelyPatterns.INSTANCE, text2.subSequence(0, it.getEndExclusive())) || it.getEndExclusive() - it.getStart() < 5 && LikelyPatterns.access$startsWithLowerCase(LikelyPatterns.INSTANCE, StringsKt.trim((CharSequence)text2.subSequence(it.getEndExclusive(), text2.length()))))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.afterWordBoundary();
        LikelyPatterns $this$PunctuationOperator_u24lambda_u2426 = INSTANCE;
        boolean bl9 = false;
        String operatorSign = "(!{1,2}|\\?{2,3}|\\.?\\?\\.?|//[?!]+|\\{\\s?(\\.\\.\\.|\u2026)\\s?\\})";
        PunctuationOperator = new RegexPattern("['\"]" + operatorSign + "['\"]|[\\p{L},:]\\s{1,4}" + operatorSign + "(\\s{1,4}[\\p{Ll},])").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::PunctuationOperator$lambda$26$lambda$25));
        TicketName = new RegexPattern("[A-Z]+-([A-Z]+-)?[0-9]+").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::TicketName$lambda$27));
        LikelyPatterns $this$Chemical_u24lambda_u2429 = INSTANCE;
        boolean bl10 = false;
        part = "\\d(,\\d)+-[A-Za-z][a-z]+ne";
        Chemical = new RegexPattern(part + "(-" + part + ")*").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::Chemical$lambda$29$lambda$28));
        LikelyPatterns $this$IsIBAN_u24lambda_u2431 = INSTANCE;
        boolean bl11 = false;
        String separator = "[\\s\u00a0]?";
        IsIBAN = new RegexPattern("[A-Z]{2}" + separator + "\\d{2}" + separator + "(?:[A-Z0-9]" + separator + "){1,30}").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsIBAN$lambda$31$lambda$30));
        IsHashLike = new RegexPattern(){

            /*
             * Unable to fully structure code
             */
            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                $this$filter$iv = super.find(text);
                $i$f$filter = false;
                var4_4 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    range = (TextRange)element$iv$iv;
                    $i$a$-filter-LikelyPatterns$IsHashLike$1$find$1 = false;
                    if (!(range.getLength() > 10)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    block10: {
                        range = (TextRange)element$iv$iv;
                        $i$a$-filter-LikelyPatterns$IsHashLike$1$find$2 = false;
                        $this$count$iv = word = text.subSequence(range.getStart(), range.getEndExclusive());
                        $i$f$count = false;
                        count$iv = 0;
                        for (var15_15 = 0; var15_15 < $this$count$iv.length(); ++var15_15) {
                            it = element$iv = $this$count$iv.charAt(var15_15);
                            $i$a$-count-LikelyPatterns$IsHashLike$1$find$2$letters$1 = false;
                            if (!Character.isLetter(it)) continue;
                            ++count$iv;
                        }
                        letters = count$iv;
                        if (letters < 5) break block10;
                        $this$count$iv = word;
                        $i$f$count = false;
                        count$iv = 0;
                        for (var15_15 = 0; var15_15 < $this$count$iv.length(); ++var15_15) {
                            it = element$iv = $this$count$iv.charAt(var15_15);
                            $i$a$-count-LikelyPatterns$IsHashLike$1$find$2$1 = false;
                            if (!Character.isDigit(it)) continue;
                            ++count$iv;
                        }
                        if (count$iv >= 5) ** GOTO lbl-1000
                    }
                    if (letters < word.length()) {
                        $this$count$iv = word;
                        $i$f$count = false;
                        count$iv = 0;
                        for (var15_15 = 0; var15_15 < $this$count$iv.length(); ++var15_15) {
                            it = element$iv = $this$count$iv.charAt(var15_15);
                            $i$a$-count-LikelyPatterns$IsHashLike$1$find$2$2 = false;
                            if (!Character.isUpperCase(it)) continue;
                            ++count$iv;
                        }
                        if (count$iv >= 5) {
                            $this$count$iv = word;
                            $i$f$count = false;
                            count$iv = 0;
                            for (var15_15 = 0; var15_15 < $this$count$iv.length(); ++var15_15) {
                                it = element$iv = $this$count$iv.charAt(var15_15);
                                $i$a$-count-LikelyPatterns$IsHashLike$1$find$2$3 = false;
                                if (!Character.isLowerCase(it)) continue;
                                ++count$iv;
                            }
                            ** if (count$iv < 5) goto lbl-1000
                        }
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                        ** GOTO lbl75
                    }
lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
lbl75:
                    // 2 sources

                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.withWordBoundariesAround();
        LicenseKey = new RegexPattern(){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange range = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!(range.getLength() > 10)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.withWordBoundariesAround();
        DatePattern = new RegexPattern(){

            /*
             * Unable to fully structure code
             */
            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                $this$filter$iv = super.find(text);
                $i$f$filter = false;
                var4_4 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    block8: {
                        block7: {
                            block6: {
                                range = (TextRange)element$iv$iv;
                                $i$a$-filter-LikelyPatterns$DatePattern$1$find$1 = false;
                                $this$any$iv = word = text.subSequence(range.getStart(), range.getEndExclusive());
                                $i$f$any = false;
                                for (var14_14 = 0; var14_14 < $this$any$iv.length(); ++var14_14) {
                                    it = element$iv = $this$any$iv.charAt(var14_14);
                                    $i$a$-any-LikelyPatterns$DatePattern$1$find$1$1 = false;
                                    if (!(it == 'Y')) continue;
                                    v0 = true;
                                    break block6;
                                }
                                v0 = false;
                            }
                            if (!v0) ** GOTO lbl-1000
                            $this$any$iv = word;
                            $i$f$any = false;
                            for (var14_14 = 0; var14_14 < $this$any$iv.length(); ++var14_14) {
                                it = element$iv = $this$any$iv.charAt(var14_14);
                                $i$a$-any-LikelyPatterns$DatePattern$1$find$1$2 = false;
                                if (!(it == 'M')) continue;
                                v1 = true;
                                break block7;
                            }
                            v1 = false;
                        }
                        if (!v1) ** GOTO lbl-1000
                        $this$any$iv = word;
                        $i$f$any = false;
                        for (var14_14 = 0; var14_14 < $this$any$iv.length(); ++var14_14) {
                            it = element$iv = $this$any$iv.charAt(var14_14);
                            $i$a$-any-LikelyPatterns$DatePattern$1$find$1$3 = false;
                            if (!(it == 'D')) continue;
                            v2 = true;
                            break block8;
                        }
                        v2 = false;
                    }
                    if (v2) {
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.withWordBoundariesAround();
        RestoredWordPart = new RegexPattern("\\[\\w{1,2}\\]\\w+").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::RestoredWordPart$lambda$32));
        IsRebusAbbreviation = new RegexPattern(){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.expandBack(new Regex("[A-Za-z]*")).afterWordBoundary();
        LikelyPatterns $this$IsExcelFormula_u24lambda_u2434 = INSTANCE;
        boolean bl12 = false;
        String funCall = "[A-Z]{3,8}\\(.+\\)";
        IsExcelFormula = new RegexPattern("=" + funCall + "( *[-+*/] *" + funCall + ")*").withWordBoundariesAround().traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsExcelFormula$lambda$34$lambda$33));
        quotes = "'\"`\u2018\u2019" + CollectionsKt.joinToString$default((Iterable)UnicodePunctuationNormalizer.Companion.getDoubleQuotes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        IsDotInBashCommand = new RegexPattern(" \\.([?" + quotes + "]| -?[a-z])").expandBack(new Regex("[a-z-]+?([" + quotes + " ]|$)")).traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsDotInBashCommand$lambda$35));
        IsInnerSentenceInQuotes = new RegexPattern(" [" + quotes + "]\\p{Lu}[^.]{5,25}\\.[" + quotes + "] \\p{Ll}").afterReversed(new Regex("\\p{Ll}")).traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsInnerSentenceInQuotes$lambda$36));
        IsGermanStreetName = new RegexPattern("[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]{4,}(str|pl|g)\\. \\d+").traceFind((Function1<? super Function0<? extends List<TextRange>>, ? extends List<TextRange>>)((Function1)LikelyPatterns::IsGermanStreetName$lambda$37));
    }
}

