/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.backend;

import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n0\u0003R\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bR\u0019\u0010\u0002\u001a\n0\u0003R\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/debugger/impl/backend/InlineBreakpointVariantModel;", "", "variant", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "initialEditorCount", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;Lkotlinx/coroutines/CoroutineScope;I)V", "getVariant", "()Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "connectedEditorsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "shouldBeDisposedOnEditorCountChange", "", "delta", "intellij.platform.debugger.impl.backend"})
final class InlineBreakpointVariantModel {
    @NotNull
    private final XLineBreakpointType.XLineBreakpointVariant variant;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicInteger connectedEditorsCount;

    public InlineBreakpointVariantModel(@NotNull XLineBreakpointType.XLineBreakpointVariant variant, @NotNull CoroutineScope cs, int initialEditorCount) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.variant = variant;
        this.cs = cs;
        this.connectedEditorsCount = new AtomicInteger(initialEditorCount);
    }

    @NotNull
    public final XLineBreakpointType.XLineBreakpointVariant getVariant() {
        return this.variant;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public final boolean shouldBeDisposedOnEditorCountChange(int delta) {
        int newCount = this.connectedEditorsCount.addAndGet(delta);
        if (newCount <= 0) {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
            return true;
        }
        return false;
    }
}

