/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.util.MathUtil;
import java.util.function.IntSupplier;

public final class ConfinedIntValue
implements IntSupplier {
    private int value;
    private final int minValue;
    private final int maxValue;

    public ConfinedIntValue(int value, int minValue, int maxValue) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public int getAsInt() {
        return this.value();
    }

    public int value() {
        return this.value;
    }

    public void inc() {
        this.update(this.value + 1);
    }

    public void dec() {
        this.update(this.value - 1);
    }

    public void update(int newValue) {
        this.value = MathUtil.clamp(newValue, this.minValue, this.maxValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfinedIntValue value1 = (ConfinedIntValue)o;
        if (this.value != value1.value) {
            return false;
        }
        if (this.minValue != value1.minValue) {
            return false;
        }
        return this.maxValue == value1.maxValue;
    }

    public int hashCode() {
        return 31 * (31 * this.value + this.minValue) + this.maxValue;
    }

    public String toString() {
        return "ConfinedIntValue[=" + this.value + "][" + this.minValue + ".." + this.maxValue + ']';
    }
}

