/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.packagesearch.packageversionutils.normalization;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion;
import org.jetbrains.packagesearch.packageversionutils.normalization.VeryLenientDateTimeExtractor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a,\u0010\u0013\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"nonSemanticSuffixOrNull", "", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "compareByTimestamp", "", "other", "HEX_STRING_LETTER_CHARS", "Lkotlin/ranges/CharRange;", "STABILITY_MARKER_REGEX", "Lkotlin/text/Regex;", "SEMVER_REGEX", "looksLikeGitCommitOrOtherHash", "", "versionName", "stabilitySuffixComponentOrNull", "ignoredPrefix", "nonSemanticSuffix", "isOneBigHexadecimalBlob", "semanticVersionPrefixOrNull", "normalizedVersion", "isStable", "releasedAt", "Lkotlinx/datetime/Instant;", "garbage", "Lkotlin/Function0;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Garbage;", "version-utils"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/UtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n648#2,5:162\n1#3:167\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/UtilsKt\n*L\n73#1:162,5\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final CharRange HEX_STRING_LETTER_CHARS = new CharRange('a', 'f');
    @NotNull
    private static final Regex STABILITY_MARKER_REGEX = new Regex("^((?:[._\\-+](?:snapshots?|preview|milestone|candidate|release|develop|stable|build|alpha|betta|final|snap|beta|dev|pre|eap|rel|sp|rc|m|r|b|a|p)(?:[._\\-]?\\d{1,5})?){1,2})(?:\\b|_)", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex SEMVER_REGEX = new Regex("^((?:\\d{1,5}\\.){0,4}\\d{1,5}(?!\\.?\\d)).*$", RegexOption.IGNORE_CASE);

    @Nullable
    public static final String nonSemanticSuffixOrNull(@NotNull NormalizedVersion $this$nonSemanticSuffixOrNull) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$nonSemanticSuffixOrNull, (String)"<this>");
        NormalizedVersion normalizedVersion = $this$nonSemanticSuffixOrNull;
        if (normalizedVersion instanceof NormalizedVersion.Semantic) {
            string = ((NormalizedVersion.Semantic)$this$nonSemanticSuffixOrNull).getNonSemanticSuffix();
        } else if (normalizedVersion instanceof NormalizedVersion.TimestampLike) {
            string = ((NormalizedVersion.TimestampLike)$this$nonSemanticSuffixOrNull).getNonSemanticSuffix();
        } else if (normalizedVersion instanceof NormalizedVersion.Garbage) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final int compareByTimestamp(@NotNull NormalizedVersion $this$compareByTimestamp, @NotNull NormalizedVersion other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareByTimestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$compareByTimestamp.getReleasedAt() == null && other.getReleasedAt() != null) {
            n = -1;
        } else if ($this$compareByTimestamp.getReleasedAt() != null && other.getReleasedAt() == null) {
            n = 1;
        } else if ($this$compareByTimestamp.getReleasedAt() != null && other.getReleasedAt() != null) {
            Instant instant = $this$compareByTimestamp.getReleasedAt();
            Intrinsics.checkNotNull((Object)instant);
            Instant instant2 = other.getReleasedAt();
            Intrinsics.checkNotNull((Object)instant2);
            n = instant.compareTo(instant2);
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean looksLikeGitCommitOrOtherHash(@NotNull String versionName) {
        String string;
        block4: {
            void var2_1;
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            String $this$takeWhile$iv = versionName;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it) || HEX_STRING_LETTER_CHARS.contains(it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block4;
            }
            string = var2_1;
        }
        void hexLookingPrefix = string;
        return switch (hexLookingPrefix.length()) {
            case 7, 40 -> true;
            default -> false;
        };
    }

    @Nullable
    public static final String stabilitySuffixComponentOrNull(@NotNull String versionName, @NotNull String ignoredPrefix) {
        List list;
        Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
        Intrinsics.checkNotNullParameter((Object)ignoredPrefix, (String)"ignoredPrefix");
        Object object = Regex.find$default((Regex)STABILITY_MARKER_REGEX, (CharSequence)StringsKt.substringAfter$default((String)versionName, (String)ignoredPrefix, null, (int)2, null), (int)0, (int)2, null);
        if (object == null || (list = object.getGroupValues()) == null) {
            return null;
        }
        List groupValues = list;
        if (groupValues.size() <= 1) {
            return null;
        }
        object = groupValues.get(1);
        String it = (String)object;
        boolean bl = false;
        return (String)(!StringsKt.isBlank((CharSequence)it) ? object : null);
    }

    @Nullable
    public static final String nonSemanticSuffix(@NotNull String versionName, @Nullable String ignoredPrefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
        String string2 = ignoredPrefix;
        if (string2 == null) {
            return null;
        }
        String string3 = UtilsKt.stabilitySuffixComponentOrNull(versionName, string2);
        if (string3 == null) {
            string3 = ignoredPrefix;
        }
        String semanticPart = string3;
        String it = string = StringsKt.substringAfter$default((String)versionName, (String)semanticPart, null, (int)2, null);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    public static final boolean isOneBigHexadecimalBlob(@NotNull String versionName) {
        Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
        boolean hasHexChars = false;
        String string = versionName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            CharRange charRange = HEX_STRING_LETTER_CHARS;
            char c2 = charRange.getFirst();
            boolean bl = c <= charRange.getLast() ? c2 <= c : false;
            if (bl) {
                hasHexChars = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return hasHexChars;
    }

    @Nullable
    public static final String semanticVersionPrefixOrNull(@NotNull String versionName) {
        Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
        Object object = Regex.find$default((Regex)SEMVER_REGEX, (CharSequence)versionName, (int)0, (int)2, null);
        if (object == null || (object = object.getGroupValues()) == null) {
            return null;
        }
        Object groupValues = object;
        if (groupValues.size() <= 1) {
            return null;
        }
        return (String)groupValues.get(1);
    }

    @NotNull
    public static final NormalizedVersion normalizedVersion(@NotNull String $this$normalizedVersion, boolean isStable, @Nullable Instant releasedAt, @NotNull Function0<NormalizedVersion.Garbage> garbage) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizedVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter(garbage, (String)"garbage");
        if (UtilsKt.looksLikeGitCommitOrOtherHash($this$normalizedVersion) || UtilsKt.isOneBigHexadecimalBlob($this$normalizedVersion)) {
            return (NormalizedVersion)garbage.invoke();
        }
        String timestampPrefix = VeryLenientDateTimeExtractor.INSTANCE.extractTimestampLookingPrefixOrNull($this$normalizedVersion);
        if (timestampPrefix != null) {
            Instant instant;
            String string = VeryLenientDateTimeExtractor.INSTANCE.extractTimestampLookingPrefixOrNull(timestampPrefix);
            return new NormalizedVersion.TimestampLike($this$normalizedVersion, isStable, string != null && (instant = InstantKt.toInstant((String)string)) != null ? instant : releasedAt, timestampPrefix, UtilsKt.stabilitySuffixComponentOrNull($this$normalizedVersion, timestampPrefix), UtilsKt.nonSemanticSuffix($this$normalizedVersion, timestampPrefix));
        }
        String semanticPart = UtilsKt.semanticVersionPrefixOrNull($this$normalizedVersion);
        if (semanticPart != null) {
            Instant instant;
            String string = VeryLenientDateTimeExtractor.INSTANCE.extractTimestampLookingPrefixOrNull(semanticPart);
            return new NormalizedVersion.Semantic($this$normalizedVersion, isStable, string != null && (instant = InstantKt.toInstant((String)string)) != null ? instant : releasedAt, semanticPart, UtilsKt.stabilitySuffixComponentOrNull($this$normalizedVersion, semanticPart), UtilsKt.nonSemanticSuffix($this$normalizedVersion, semanticPart));
        }
        return (NormalizedVersion)garbage.invoke();
    }
}

