/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.execution.ExecutionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.jetbrains.performancePlugin.commands.PerformanceCommand;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenRunAnythingProvider;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.performancePlugin.dto.MavenGoalConfigurationDto;
import org.jetbrains.idea.maven.performancePlugin.utils.MavenCommandsExecutionListener;
import org.jetbrains.idea.maven.performancePlugin.utils.MavenConfigurationUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "executeGoalAsRunAnything", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/maven/performancePlugin/dto/MavenGoalConfigurationDto;", "executeGoalsFromLifecycle", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getName", "Companion", "intellij.maven"})
public final class ExecuteMavenGoalCommand
extends PerformanceCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "executeMavenGoals";
    @NotNull
    public static final String PREFIX = "%executeMavenGoals";

    public ExecuteMavenGoalCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    private final void executeGoalAsRunAnything(Project project, MavenGoalConfigurationDto settings) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext context2 = dataContext;
        new MavenRunAnythingProvider().execute(context2, "mvn " + CollectionsKt.joinToString$default((Iterable)settings.getGoals(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
    }

    private final void executeGoalsFromLifecycle(Project project, MavenGoalConfigurationDto settings) {
        MavenRunnerParameters params = MavenConfigurationUtils.INSTANCE.createRunnerParams(project, settings);
        MavenRunConfigurationType.runConfiguration(project, params, null);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        AsyncPromise promise = new AsyncPromise();
        MavenGoalConfigurationDto settings = (MavenGoalConfigurationDto)this.deserializeOptionsFromJson(this.extractCommandArgument(PREFIX), MavenGoalConfigurationDto.class);
        project2.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new MavenCommandsExecutionListener((AsyncPromise<Object>)promise));
        ApplicationManager.getApplication().invokeLater(() -> ExecuteMavenGoalCommand._execute$lambda$0(settings, this, project2, promise));
        return (Promise)promise;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    private static final void _execute$lambda$0(MavenGoalConfigurationDto $settings, ExecuteMavenGoalCommand this$0, Project $project, AsyncPromise $promise) {
        try {
            if ($settings.getRunAnything()) {
                Intrinsics.checkNotNull((Object)$settings);
                this$0.executeGoalAsRunAnything($project, $settings);
            } else {
                Intrinsics.checkNotNull((Object)$settings);
                this$0.executeGoalsFromLifecycle($project, $settings);
            }
        }
        catch (Throwable t) {
            $promise.setError(t);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

