/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.Context;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertFunctionToPropertyIntentionKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertFunctionToPropertyIntention;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "isElementApplicable", "", "perform", "Lcom/intellij/modcommand/ModCommand;", "isApplicableByPsi", "isApplicableByAnalyze", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nConvertFunctionToPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertFunctionToPropertyIntention\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,332:1\n30#2,2:333\n30#2,2:350\n36#3,15:335\n36#3,15:352\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertFunctionToPropertyIntention\n*L\n63#1:333,2\n92#1:350,2\n63#1:335,15\n92#1:352,15\n*E\n"})
public final class ConvertFunctionToPropertyIntention
extends PsiBasedModCommandAction<KtNamedFunction> {
    public ConvertFunctionToPropertyIntention() {
        super(null, KtNamedFunction.class);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.function.to.property", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
        return presentation;
    }

    protected boolean isElementApplicable(@NotNull KtNamedFunction element, @NotNull ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.isApplicableByPsi(element, context2) && this.isApplicableByAnalyze(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected ModCommand perform(@NotNull ActionContext context2, @NotNull KtNamedFunction element) {
        Context context3;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement useSiteElement$iv = (KtElement)element;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Context context4;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl = false;
                KaSession $this$perform_u24lambda_u240 = analysisSession$iv$iv;
                boolean bl2 = false;
                context4 = ConvertFunctionToPropertyIntentionKt.access$prepareContext($this$perform_u24lambda_u240, element);
            }
            context3 = context4;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        Context context5 = context3;
        if (context5 == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        Context elementContext = context5;
        ModCommand modCommand = ModCommand.showConflicts(elementContext.getConflicts()).andThen(ModCommand.psiUpdate((PsiElement)((PsiElement)element), (arg_0, arg_1) -> ConvertFunctionToPropertyIntention.perform$lambda$1(elementContext, context2, arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"andThen(...)");
        return modCommand;
    }

    private final boolean isApplicableByPsi(KtNamedFunction element, ActionContext context2) {
        PsiElement psiElement = element.getFunKeyword();
        if (psiElement == null) {
            return false;
        }
        PsiElement funKeyword = psiElement;
        PsiElement psiElement2 = element.getNameIdentifier();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement identifier = psiElement2;
        if (!new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), PsiTreeUtilKt.getEndOffset((PsiElement)identifier)).containsOffset(context2.offset())) {
            return false;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        boolean bl = ktClass != null ? KotlinPsiUtilsKt.isFunInterface(ktClass) : false;
        if (bl && !element.hasBody()) {
            return false;
        }
        List list2 = element.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        if (!((Collection)list2).isEmpty() || element.isLocal()) {
            return false;
        }
        String string = element.getName();
        if (string == null) {
            return false;
        }
        String name2 = string;
        return !Intrinsics.areEqual((Object)name2, (Object)"invoke") && !Intrinsics.areEqual((Object)name2, (Object)"iterator") && !((ImmutableSet)OperatorConventions.UNARY_OPERATION_NAMES.inverse().keySet()).contains((Object)Name.identifier((String)name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isApplicableByAnalyze(KtNamedFunction element) {
        void this_$iv$iv;
        KtElement useSiteElement$iv = (KtElement)element;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                String string;
                block14: {
                    block13: {
                        try {
                            boolean bl = false;
                            KaSession $this$isApplicableByAnalyze_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            KaFunctionSymbol functionSymbol = $this$isApplicableByAnalyze_u24lambda_u240.getSymbol(element);
                            KaType returnType = functionSymbol.getReturnType();
                            if (!$this$isApplicableByAnalyze_u24lambda_u240.isUnitType(returnType) && !$this$isApplicableByAnalyze_u24lambda_u240.isNothingType(returnType)) break block13;
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var9_9
                            boolean bl4 = bl3;
                            return bl4;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Throwable throwable$iv$iv) {
                                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    if (ConvertFunctionToPropertyIntentionKt.access$getPropertyName(element) != null) break block14;
                    boolean bl = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 8] lbl29 : MonitorExitStatement: MONITOREXIT : var9_9
                    boolean bl5 = bl;
                    return bl5;
                }
                String propertyName = string;
                KtProperty existingProperty = ConvertFunctionToPropertyIntentionKt.access$findExistingPropertyWithSameName(element, propertyName);
                boolean bl = existingProperty == null;
                // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl36 : MonitorExitStatement: MONITOREXIT : var9_9
                boolean bl6 = bl;
                return bl6;
            }
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    private static final void perform$lambda$1(Context $elementContext, ActionContext $context, KtNamedFunction element, ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        ConvertFunctionToPropertyIntentionKt.access$convertFunctionToProperty(element, $elementContext, updater2, $context);
    }
}

