/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.scratch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.K1KotlinScratchFile;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.ClearScratchAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.IsMakeBeforeRunAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.StopScratchAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ModulesComboBoxAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileOptions;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.SmallBorderCheckboxAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchTopPanel;", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/K1KotlinScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/K1KotlinScratchFile;)V", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/K1KotlinScratchFile;", "actionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getActionsToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "setupTopPanelUpdateHandlers", "", "createUpdateToolbarHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandlerAdapter;", "IsInteractiveCheckboxAction", "IsReplCheckboxAction", "kotlin.jvm.k1"})
public final class ScratchTopPanel {
    @NotNull
    private final K1KotlinScratchFile scratchFile;
    @NotNull
    private final ActionToolbar actionsToolbar;

    public ScratchTopPanel(@NotNull K1KotlinScratchFile scratchFile2) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)scratchFile2, (String)"scratchFile");
        this.scratchFile = scratchFile2;
        this.setupTopPanelUpdateHandlers();
        ModulesComboBoxAction modulesComboBoxAction = new ModulesComboBoxAction(this.scratchFile, (Function1<? super Module, Unit>)((Function1)arg_0 -> ScratchTopPanel._init_$lambda$0(this, arg_0)));
        DefaultActionGroup $this$_init__u24lambda_u241 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u241.add((AnAction)new RunScratchAction());
        $this$_init__u24lambda_u241.add((AnAction)new StopScratchAction());
        $this$_init__u24lambda_u241.addSeparator();
        $this$_init__u24lambda_u241.add((AnAction)new ClearScratchAction());
        $this$_init__u24lambda_u241.addSeparator();
        $this$_init__u24lambda_u241.add((AnAction)modulesComboBoxAction);
        $this$_init__u24lambda_u241.add((AnAction)new IsMakeBeforeRunAction(this.scratchFile));
        $this$_init__u24lambda_u241.addSeparator();
        $this$_init__u24lambda_u241.add((AnAction)new IsInteractiveCheckboxAction());
        $this$_init__u24lambda_u241.addSeparator();
        $this$_init__u24lambda_u241.add((AnAction)new IsReplCheckboxAction());
        DefaultActionGroup toolbarGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        this.actionsToolbar = actionToolbar;
    }

    @NotNull
    public final K1KotlinScratchFile getScratchFile() {
        return this.scratchFile;
    }

    @NotNull
    public final ActionToolbar getActionsToolbar() {
        return this.actionsToolbar;
    }

    private final void setupTopPanelUpdateHandlers() {
        block1: {
            ScratchOutputHandlerAdapter toolbarHandler = this.createUpdateToolbarHandler();
            SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
            if (sequentialScratchExecutor != null) {
                sequentialScratchExecutor.addOutputHandler(toolbarHandler);
            }
            ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
            if (scratchExecutor == null) break block1;
            scratchExecutor.addOutputHandler(toolbarHandler);
        }
    }

    private final ScratchOutputHandlerAdapter createUpdateToolbarHandler() {
        return new ScratchOutputHandlerAdapter(this){
            final /* synthetic */ ScratchTopPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStart(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchUtilsKt.updateToolbar(this.this$0.getActionsToolbar());
            }

            public void onFinish(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchUtilsKt.updateToolbar(this.this$0.getActionsToolbar());
            }
        };
    }

    private static final Unit _init_$lambda$0(ScratchTopPanel this$0, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScratchUtilsKt.updateToolbar(this$0.actionsToolbar);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchTopPanel$IsInteractiveCheckboxAction;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/SmallBorderCheckboxAction;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchTopPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isInteractiveMode", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "kotlin.jvm.k1"})
    private final class IsInteractiveCheckboxAction
    extends SmallBorderCheckboxAction {
        public IsInteractiveCheckboxAction() {
            Object[] objectArray = new Object[]{2L};
            super(KotlinJvmBundle.message("scratch.is.interactive.checkbox", new Object[0]), KotlinJvmBundle.message("scratch.is.interactive.checkbox.description", objectArray));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return ScratchTopPanel.this.getScratchFile().getOptions().isInteractiveMode();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isInteractiveMode) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ScratchTopPanel.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)arg_0 -> IsInteractiveCheckboxAction.setSelected$lambda$0(isInteractiveMode, arg_0)));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private static final ScratchFileOptions setSelected$lambda$0(boolean $isInteractiveMode, ScratchFileOptions $this$saveOptions) {
            Intrinsics.checkNotNullParameter((Object)$this$saveOptions, (String)"$this$saveOptions");
            return ScratchFileOptions.copy$default($this$saveOptions, false, false, $isInteractiveMode, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchTopPanel$IsReplCheckboxAction;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/SmallBorderCheckboxAction;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchTopPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isRepl", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "kotlin.jvm.k1"})
    private final class IsReplCheckboxAction
    extends SmallBorderCheckboxAction {
        public IsReplCheckboxAction() {
            super(KotlinJvmBundle.message("scratch.is.repl.checkbox", new Object[0]), KotlinJvmBundle.message("scratch.is.repl.checkbox.description", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return ScratchTopPanel.this.getScratchFile().getOptions().isRepl();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isRepl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ScratchTopPanel.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)arg_0 -> IsReplCheckboxAction.setSelected$lambda$0(isRepl, arg_0)));
                if (isRepl) break block1;
                SequentialScratchExecutor sequentialScratchExecutor = ScratchTopPanel.this.getScratchFile().getReplScratchExecutor();
                if (sequentialScratchExecutor != null) {
                    sequentialScratchExecutor.stop();
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private static final ScratchFileOptions setSelected$lambda$0(boolean $isRepl, ScratchFileOptions $this$saveOptions) {
            Intrinsics.checkNotNullParameter((Object)$this$saveOptions, (String)"$this$saveOptions");
            return ScratchFileOptions.copy$default($this$saveOptions, $isRepl, false, false, 6, null);
        }
    }
}

