/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\b*\u00020\u0006J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0006H\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorUtils;", "", "<init>", "()V", "canMoveToConstructor", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "moveToConstructor", "", "findConstructorParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getTextWithUseSite", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "render", "Lorg/jetbrains/kotlin/types/KotlinType;", "isValidInConstructor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMovePropertyToConstructorIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovePropertyToConstructorIntention.kt\norg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorUtils\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,138:1\n249#2:139\n*S KotlinDebug\n*F\n+ 1 MovePropertyToConstructorIntention.kt\norg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorUtils\n*L\n121#1:139\n*E\n"})
public final class MovePropertyToConstructorUtils {
    @NotNull
    public static final MovePropertyToConstructorUtils INSTANCE = new MovePropertyToConstructorUtils();

    private MovePropertyToConstructorUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canMoveToConstructor(@NotNull KtProperty $this$canMoveToConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$canMoveToConstructor, (String)"<this>");
        if (!org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils.INSTANCE.isMovableToConstructorByPsi($this$canMoveToConstructor)) return false;
        KtExpression ktExpression = $this$canMoveToConstructor.getInitializer();
        if (ktExpression == null) return true;
        boolean bl = this.isValidInConstructor(ktExpression);
        if (!bl) return false;
        return true;
    }

    public final void moveToConstructor(@NotNull KtProperty $this$moveToConstructor) {
        String propertyAnnotationsText;
        Intrinsics.checkNotNullParameter((Object)$this$moveToConstructor, (String)"<this>");
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)$this$moveToConstructor), KtClass.class);
        if (ktClass == null) {
            return;
        }
        KtClass parentClass = ktClass;
        Project project = $this$moveToConstructor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtPrimaryConstructor primaryConstructor = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)parentClass);
        KtParameter constructorParameter = this.findConstructorParameter($this$moveToConstructor);
        CommentSaver commentSaver = new CommentSaver((PsiElement)$this$moveToConstructor, false, 2, null);
        BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$moveToConstructor, BodyResolveMode.PARTIAL);
        Object object = $this$moveToConstructor.getModifierList();
        String string = object != null && (object = object.getAnnotationEntries()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)" ", null, null, (int)0, null, arg_0 -> MovePropertyToConstructorUtils.moveToConstructor$lambda$0(context2, arg_0), (int)30, null) : (propertyAnnotationsText = null);
        if (constructorParameter != null) {
            PsiElement psiElement;
            String parameterText = org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils.INSTANCE.buildReplacementConstructorParameterText($this$moveToConstructor, constructorParameter, propertyAnnotationsText);
            PsiElement $this$moveToConstructor_u24lambda_u241 = psiElement = constructorParameter.replace((PsiElement)psiFactory.createParameter(parameterText));
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$moveToConstructor_u24lambda_u241);
            CommentSaver.restore$default(commentSaver, $this$moveToConstructor_u24lambda_u241, false, 2, null);
        } else {
            VariableDescriptor variableDescriptor;
            VariableDescriptor variableDescriptor2;
            Object object2 = $this$moveToConstructor.getTypeReference();
            if (object2 == null || (object2 = object2.getText()) == null) {
                variableDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default($this$moveToConstructor, null, 1, null);
                PropertyDescriptor propertyDescriptor = variableDescriptor2 instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor2 : null;
                if (propertyDescriptor != null && (propertyDescriptor = propertyDescriptor.getType()) != null) {
                    object2 = this.render((KotlinType)propertyDescriptor);
                } else {
                    return;
                }
            }
            Object typeText = object2;
            String parameterText = org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils.INSTANCE.buildAdditionalConstructorParameterText($this$moveToConstructor, (String)typeText, propertyAnnotationsText);
            KtParameterList ktParameterList = primaryConstructor.getValueParameterList();
            if (ktParameterList != null && (ktParameterList = ktParameterList.addParameter(psiFactory.createParameter(parameterText))) != null) {
                VariableDescriptor $this$moveToConstructor_u24lambda_u242 = variableDescriptor2 = ktParameterList;
                boolean bl = false;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)$this$moveToConstructor_u24lambda_u242, null, 2, null);
                CommentSaver.restore$default(commentSaver, (PsiElement)$this$moveToConstructor_u24lambda_u242, false, 2, null);
                variableDescriptor = variableDescriptor2;
            } else {
                variableDescriptor = null;
            }
            PsiElement cfr_ignored_0 = (PsiElement)variableDescriptor;
        }
        $this$moveToConstructor.delete();
    }

    private final KtParameter findConstructorParameter(KtProperty $this$findConstructorParameter) {
        KtExpression ktExpression = $this$findConstructorParameter.getInitializer();
        KtReferenceExpression ktReferenceExpression = ktExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression : null;
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression reference = ktReferenceExpression;
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)reference, null, 1, null);
        CallableDescriptor callableDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        ParameterDescriptor parameterDescriptor = callableDescriptor instanceof ParameterDescriptor ? (ParameterDescriptor)callableDescriptor : null;
        if (parameterDescriptor == null) {
            return null;
        }
        ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
        SourceElement sourceElement = parameterDescriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        ktExpression = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        return ktExpression instanceof KtParameter ? (KtParameter)ktExpression : null;
    }

    private final String getTextWithUseSite(KtAnnotationEntry $this$getTextWithUseSite, BindingContext context2) {
        String string;
        if ($this$getTextWithUseSite.getUseSiteTarget() != null) {
            String string2 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return string2;
        }
        Object object = $this$getTextWithUseSite.getTypeReference();
        if (object == null || (object = object.getText()) == null) {
            String string3 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            return string3;
        }
        Object typeReference = object;
        KtValueArgumentList ktValueArgumentList = $this$getTextWithUseSite.getValueArgumentList();
        String string4 = ktValueArgumentList != null ? ktValueArgumentList.getText() : null;
        if (string4 == null) {
            string4 = "";
        }
        String valueArgumentList = string4;
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$getTextWithUseSite);
        if (annotationDescriptor == null) {
            String string5 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            return string5;
        }
        AnnotationDescriptor descriptor2 = annotationDescriptor;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(descriptor2);
        if (!applicableTargets.contains(KotlinTarget.VALUE_PARAMETER)) {
            String string6 = $this$getTextWithUseSite.getText();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        } else if (applicableTargets.contains(KotlinTarget.PROPERTY)) {
            string = MovePropertyToConstructorUtils.getTextWithUseSite$textWithMe(AnnotationUseSiteTarget.PROPERTY, (String)typeReference, valueArgumentList);
        } else if (applicableTargets.contains(KotlinTarget.FIELD)) {
            string = MovePropertyToConstructorUtils.getTextWithUseSite$textWithMe(AnnotationUseSiteTarget.FIELD, (String)typeReference, valueArgumentList);
        } else {
            String string7 = $this$getTextWithUseSite.getText();
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        }
        return string;
    }

    private final String render(KotlinType $this$render) {
        return IdeDescriptorRenderers.SOURCE_CODE.renderType($this$render);
    }

    private final boolean isValidInConstructor(KtExpression $this$isValidInConstructor) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isValidInConstructor;
        boolean $i$f$getStrictParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass == null) {
            return false;
        }
        KtClass containingClass = ktClass;
        Ref.BooleanRef isValid = new Ref.BooleanRef();
        isValid.element = true;
        $this$isValidInConstructor.accept((PsiElementVisitor)new PsiRecursiveVisitor(containingClass, isValid){
            final /* synthetic */ KtClass $containingClass;
            final /* synthetic */ Ref.BooleanRef $isValid;
            {
                this.$containingClass = $containingClass;
                this.$isValid = $isValid;
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitReferenceExpression(KtReferenceExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)expression, null, 1, null);
                if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall declarationDescriptor = resolvedCall;
                if (Intrinsics.areEqual((Object)declarationDescriptor.getContainingDeclaration(), (Object)SearchHelpersKt.getDescriptor((KtDeclaration)this.$containingClass))) {
                    this.$isValid.element = false;
                }
            }
        });
        return isValid.element;
    }

    private static final CharSequence moveToConstructor$lambda$0(BindingContext $context, KtAnnotationEntry it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.getTextWithUseSite(it, $context);
    }

    private static final String getTextWithUseSite$textWithMe(AnnotationUseSiteTarget $this$getTextWithUseSite_u24textWithMe, String typeReference, String valueArgumentList) {
        return "@" + $this$getTextWithUseSite_u24textWithMe.getRenderName() + ":" + typeReference + valueArgumentList;
    }
}

