/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentWrapper;
import org.jetbrains.kotlin.psi.KtCodeFragment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentPatcher;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "expressionWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentWrapper;", "addWrapper", "wrapper", "wrapFragmentExpressionIfNeeded", "", "kotlin.jvm-debugger.evaluation"})
final class KotlinCodeFragmentPatcher {
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final List<KotlinCodeFragmentWrapper> expressionWrappers;

    public KotlinCodeFragmentPatcher(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.expressionWrappers = new ArrayList();
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final KotlinCodeFragmentPatcher addWrapper(@NotNull KotlinCodeFragmentWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.expressionWrappers.add(wrapper);
        return this;
    }

    public final void wrapFragmentExpressionIfNeeded() {
        for (KotlinCodeFragmentWrapper wrapper : this.expressionWrappers) {
            wrapper.transformIfNeeded(this.codeFragment);
        }
    }
}

