/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.impl.HyperlinkInfoFactoryImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.InlineFunctionHyperLinkInfo;
import org.jetbrains.kotlin.idea.debugger.core.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.SourceLineKind;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/ExceptionFilter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "file", "fqClass", "methodName", "patchResult", "result", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "defaultResult", "createHyperlinks", "Lorg/jetbrains/kotlin/idea/debugger/core/InlineFunctionHyperLinkInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parseNativeStackTraceLine", "rawLine", "Companion", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinExceptionFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExceptionFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,206:1\n1563#2:207\n1634#2,3:208\n1625#2:211\n1869#2:212\n1870#2:214\n1626#2:215\n1#3:213\n1#3:218\n11887#4:216\n13805#4:217\n13806#4:219\n11888#4:220\n*S KotlinDebug\n*F\n+ 1 KotlinExceptionFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter\n*L\n42#1:207\n42#1:208,3\n77#1:211\n77#1:212\n77#1:214\n77#1:215\n77#1:213\n79#1:218\n79#1:216\n79#1:217\n79#1:219\n79#1:220\n*E\n"})
public final class KotlinExceptionFilter
extends ExceptionFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
    private static final Pattern LINE_COLUMN_PATTERN = Pattern.compile("(\\d+):(\\d+)");

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        super(searchScope);
        this.searchScope = searchScope;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return (Filter.Result)ReadAction.nonBlocking(() -> KotlinExceptionFilter.applyFilter$lambda$0(this, line, entireLength)).executeSynchronously();
    }

    @Nullable
    public final Filter.Result applyFilter(int line, @NotNull String file, @NotNull String fqClass, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fqClass, (String)"fqClass");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        String stackLine = "at " + fqClass + "." + methodName + "(" + file + ":" + line + ")";
        return this.applyFilter(stackLine, stackLine.length());
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        void $this$mapTo$iv$iv;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line, result2);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        List list2 = result2.getResultItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResultItems(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes()));
        }
        List list3 = (List)destination$iv$iv;
        return new Filter.Result(list3);
    }

    /*
     * WARNING - void declaration
     */
    private final HyperlinkInfo createHyperlinkInfo(String line, Filter.Result defaultResult) {
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String string = stackTraceElement2.getFileName();
        if (string == null) {
            return null;
        }
        String fileName = string;
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            return null;
        }
        String fullyQualifiedName = stackTraceElement2.getClassName();
        int lineNumber = stackTraceElement2.getLineNumber() - 1;
        Intrinsics.checkNotNull((Object)fullyQualifiedName);
        String internalName = JvmNameUtilsKt.fqnToInternalName(fullyQualifiedName);
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile file = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project2, this.searchScope, jvmClassName2, fileName);
        if (file == null) {
            void $this$mapNotNullTo$iv;
            List list2 = defaultResult.getResultItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResultItems(...)");
            Iterable iterable = list2;
            Object[] destination$iv = (Object[])new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                Filter.ResultItem it = (Filter.ResultItem)element$iv;
                boolean bl2 = false;
                FileHyperlinkInfo fileHyperlinkInfo = it instanceof FileHyperlinkInfo ? (FileHyperlinkInfo)it : null;
                if ((fileHyperlinkInfo != null && (fileHyperlinkInfo = fileHyperlinkInfo.getDescriptor()) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getFile()) != null ? fileHyperlinkInfo.getName() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            HashSet defaultLinkFileNames = (HashSet)destination$iv;
            if (!defaultLinkFileNames.contains(fileName)) {
                void $this$mapNotNullTo$iv2;
                PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)project2, (String)fileName, (GlobalSearchScope)this.searchScope);
                Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesByName(...)");
                destination$iv = psiFileArray;
                Collection destination$iv2 = new HashSet();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv2 = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach2 = false;
                int n = ((void)$this$forEach$iv$iv2).length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile it$iv;
                    void element$iv$iv;
                    void element$iv = element$iv$iv = $this$forEach$iv$iv2[j];
                    boolean bl = false;
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl4 = false;
                    if ((!it.isValid() ? null : it.getVirtualFile()) == null) continue;
                    it$iv = it$iv;
                    boolean bl5 = false;
                    destination$iv2.add(it$iv);
                }
                HashSet filesByName = (HashSet)destination$iv2;
                if (!((Collection)filesByName).isEmpty()) {
                    return filesByName.size() > 1 ? HyperlinkInfoFactoryImpl.getInstance().createMultipleFilesHyperlinkInfo(CollectionsKt.toList((Iterable)filesByName), lineNumber, project2) : (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, (VirtualFile)CollectionsKt.first((Iterable)filesByName), lineNumber);
                }
            }
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        InlineFunctionHyperLinkInfo hyperlinkInfoForInline = this.createHyperlinks(jvmClassName2, virtualFile2, lineNumber + 1, project2);
        if (hyperlinkInfoForInline != null) {
            return (HyperlinkInfo)hyperlinkInfoForInline;
        }
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile2, lineNumber);
    }

    private final InlineFunctionHyperLinkInfo createHyperlinks(JvmClassName jvmName, VirtualFile file, int line, Project project) {
        if (!InlineUtilsKt.isInlineFrameLineNumber(file, line, project)) {
            return null;
        }
        SMAP sMAP = KotlinSourceMapCache.Companion.getInstance(project).getSourceMap(file, jvmName);
        if (sMAP == null) {
            return null;
        }
        SMAP smapData = sMAP;
        ArrayList<InlineFunctionHyperLinkInfo.InlineInfo> inlineInfos = new ArrayList<InlineFunctionHyperLinkInfo.InlineInfo>();
        Pair<KtFile, Integer> pair = SmapUtilKt.mapStacktraceLineToSource(smapData, line, project, SourceLineKind.EXECUTED_LINE, this.searchScope);
        if (pair == null) {
            return null;
        }
        Pair<KtFile, Integer> pair2 = pair;
        KtFile inlineFunctionBodyFile = (KtFile)pair2.component1();
        int inlineFunctionBodyLine = ((Number)pair2.component2()).intValue();
        VirtualFile virtualFile = inlineFunctionBodyFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.InlineFunctionBodyInfo(virtualFile, inlineFunctionBodyLine));
        Pair<KtFile, Integer> inlineFunCallInfo = SmapUtilKt.mapStacktraceLineToSource(smapData, line, project, SourceLineKind.CALL_LINE, this.searchScope);
        if (inlineFunCallInfo != null) {
            Pair<KtFile, Integer> pair3 = inlineFunCallInfo;
            KtFile callSiteFile = (KtFile)pair3.component1();
            int callSiteLine = ((Number)pair3.component2()).intValue();
            VirtualFile virtualFile2 = callSiteFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.CallSiteInfo(virtualFile2, callSiteLine));
        }
        return new InlineFunctionHyperLinkInfo(project, (List<? extends InlineFunctionHyperLinkInfo.InlineInfo>)inlineInfos);
    }

    private final Filter.Result parseNativeStackTraceLine(String rawLine, int entireLength) {
        String atPrefix = "at ";
        String ktExtension = ".kt:";
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        String line = ((Object)StringsKt.trim((CharSequence)rawLine)).toString();
        if (!StringsKt.startsWith$default((String)line, (String)atPrefix, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)line, (char)')', (boolean)false, (int)2, null)) {
            return null;
        }
        int fileNameBegin = StringsKt.lastIndexOf$default((CharSequence)line, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
        if (fileNameBegin < 1) {
            return null;
        }
        int fileNameEnd = StringsKt.indexOf$default((CharSequence)line, (String)ktExtension, (int)fileNameBegin, (boolean)false, (int)4, null) + ktExtension.length() - 1;
        if (fileNameEnd < ktExtension.length() - 1) {
            return null;
        }
        String string = line.substring(fileNameBegin, fileNameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        VirtualFile virtualFile = KotlinExceptionFilter.Companion.findFile(string);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string2 = line.substring(fileNameEnd + 1, StringsKt.getLastIndex((CharSequence)line));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Pair pair = KotlinExceptionFilter.Companion.parsLineColumn(string2);
        int lineNumber = ((Number)pair.component1()).intValue();
        int columnNumber = ((Number)pair.component2()).intValue();
        int offset = entireLength - rawLine.length() + StringsKt.indexOf$default((CharSequence)rawLine, (String)atPrefix, (int)0, (boolean)false, (int)6, null);
        int highlightEndOffset = offset + (lineNumber > 0 ? StringsKt.getLastIndex((CharSequence)line) : fileNameEnd);
        OpenFileHyperlinkInfo hyperLinkInfo = new OpenFileHyperlinkInfo(project2, virtualFile2, Math.max(0, lineNumber - 1), columnNumber);
        return new Filter.Result(offset + fileNameBegin, highlightEndOffset, (HyperlinkInfo)hyperLinkInfo);
    }

    private static final Filter.Result applyFilter$lambda$0(KotlinExceptionFilter this$0, String $line, int $entireLength) {
        Filter.Result result2;
        Filter.Result result3 = result2 = super.applyFilter($line, $entireLength);
        return result3 == null ? this$0.parseNativeStackTraceLine($line, $entireLength) : this$0.patchResult(result3, $line);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinExceptionFilter$Companion;", "", "<init>", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LINE_COLUMN_PATTERN", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "parsLineColumn", "Lkotlin/Pair;", "", "locationLine", "intellij.kotlin.jvm.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher = STACK_TRACE_ELEMENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                String declaringClass = matcher.group(1);
                String methodName = matcher.group(2);
                String fileName = matcher.group(3);
                String lineNumber = matcher.group(4);
                return new StackTraceElement(declaringClass, methodName, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private final VirtualFile findFile(String fileName) {
            if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
                return null;
            }
            String string = FileUtil.toSystemIndependentName((String)fileName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String vfsFileName = string;
            return LocalFileSystem.getInstance().findFileByPath(vfsFileName);
        }

        private final Pair<Integer, Integer> parsLineColumn(String locationLine) {
            Matcher matcher = LINE_COLUMN_PATTERN.matcher(locationLine);
            if (matcher.matches()) {
                int line = Integer.parseInt(matcher.group(1));
                int column = Integer.parseInt(matcher.group(2));
                return new Pair((Object)line, (Object)column);
            }
            return new Pair((Object)0, (Object)0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

