/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class RussianTreePatterns {
    static final Quotes quotes = new Quotes("\u00ab\u00bb \u201e\u201c \u201c\u201d \u2018\u2019");
    static final NodePattern definitelyOpeningQuotations = quotes.definitelyOpening();
    static final NodePattern definitelyClosingQuotations = quotes.definitelyClosing();
    static final NodePattern openingQuotations = quotes.opening();
    static final NodePattern closingQuotations = quotes.closing();
    static final NodePattern anyQuotation = NodePattern.or(quotes.any(), NodePattern.N.form("\u2026|\\.{3}|.*\".*"));
    static final NodePattern clause = NodePattern.or(NodePattern.N.pos("VB.*"), NodePattern.N.withDependent("cop|aux.*|nsubj.*|csubj|advcl"));
    static final String nominalHeads = "nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound";
    static final String clausalRelations = "advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis";
    static final NodePattern whWord = NodePattern.or(NodePattern.N.lemma("\u043a\u043e\u0442\u043e\u0440\u044b\u0439|\u0433\u0434\u0435|\u043a\u0443\u0434\u0430|\u0437\u0430\u0447\u0435\u043c|\u0441\u043a\u043e\u043b\u044c\u043a\u043e|\u043a\u0430\u043a\u043e\u0439|\u043a\u0442\u043e|\u043a\u043e\u0433\u0434\u0430"), NodePattern.N.form("\u0447\u0442\u043e"), NodePattern.N.form("\u043f\u043e\u0447\u0435\u043c\u0443").noDependents(), NodePattern.N.form("\u043a\u0430\u043a").noDependents("fixed"), NodePattern.N.form("\u0447\u0442\u043e\u0431\u044b").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0442\u043e\u0433\u043e|\u0442\u0435\u043c"))), NodePattern.N.lemma("\u0447\u0442\u043e").noHeadRelation("mark"));
    static final NodePattern whPhrase = NodePattern.custom(n -> RussianTreePatterns.findWh(n) != null);
    static final NodePattern dashes = NodePattern.N.form("[-\u2013\u2014\u2015]+");
    static final NodePattern emphasis = NodePattern.or(NodePattern.N.form("\u0442\u043e\u043b\u044c\u043a\u043e|\u043b\u0438\u0448\u044c|\u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e|\u0438\u043c\u0435\u043d\u043d\u043e|\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e|\u0434\u0430\u0436\u0435"), NodePattern.N.inFormSequence(1, "\u0432", "\u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e\u0441\u0442\u0438"));
    static final NodePattern finiteVerb = NodePattern.N.pos("VB:(Real|Past|Fut).*");
    static final String subjectRelations = "nsubj.*|csubj.*";
    static final NodePattern infinitive = NodePattern.N.pos("VB:INF.*");
    static final NodePattern commaOrStronger = NodePattern.or(NodePattern.PUNCT.form(".*[,.;:!?|/].*"), CommonPatterns.arrow, CommonPatterns.ellipsis);
    static final NodePattern wordInternalPunctuation = NodePattern.N.form("\\p{L}+\\.\\p{L}+");
    private static final NodePattern whatA = NodePattern.N.form("\u0437\u0430").withPrevSibling(NodePattern.N.form("\u0447\u0442\u043e|\u0448\u043e")).withHead("case", Case.Nom.posPattern);
    static final NodePattern aNo = NodePattern.N.form("\u0430|\u043d\u043e");
    static final NodePattern foreignWord = NodePattern.N.withHeadRelation("flat:foreign");
    private static final Set<String> oPrepositions = Set.of("\u0441\u043e", "\u0438\u0437\u043e", "\u043e\u0442\u043e", "\u0432\u043e", "\u043a\u043e", "\u043f\u043e\u0434\u043e", "\u043d\u0430\u0434\u043e", "\u043f\u0435\u0440\u0435\u0434\u043e");

    RussianTreePatterns() {
    }

    @Nullable
    static Node findWh(Node node) {
        for (Node dependent : node.allDependents()) {
            if (whWord.matches(dependent)) {
                return dependent;
            }
            if (dependent.hasHeadRelation("conj|punct|case|cc|acl")) continue;
            return RussianTreePatterns.findWh(dependent);
        }
        return null;
    }

    @Nullable
    static Node findOwnPreposition(Node node) {
        Node result = node.findDependents("case").stream().findFirst().orElse(null);
        if (whatA.matches(result)) {
            return null;
        }
        if (result != null) {
            return result;
        }
        result = node.findSingleDependent("mark");
        if (result != null && result.hasPos("PREP")) {
            return result;
        }
        Node prev = node.prevNode();
        return prev != null && node.hasHeadRelation("flat:foreign") && prev.hasHeadRelation("case") ? prev : null;
    }

    static String normalizePreposition(String lowForm) {
        if (lowForm.equals("\u043e\u0431") || lowForm.equals("\u043e\u0431\u043e")) {
            return "\u043e";
        }
        if (oPrepositions.contains(lowForm)) {
            return lowForm.substring(0, lowForm.length() - 1);
        }
        return lowForm;
    }
}

