/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.rules.AbstractNumberInWordFilter;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;

public class EnglishNumberInWordFilter
extends AbstractNumberInWordFilter {
    private static MorfologikAmericanSpellerRule englishSpellerRule;

    public EnglishNumberInWordFilter() throws IOException {
        super((Language)AmericanEnglish.getInstance());
        ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale(this.language.getShortCode()));
        if (englishSpellerRule == null) {
            englishSpellerRule = new MorfologikAmericanSpellerRule(messages, (Language)AmericanEnglish.getInstance());
        }
    }

    public boolean isMisspelled(String word) throws IOException {
        return englishSpellerRule.isMisspelled(word);
    }

    protected List<String> getSuggestions(String word) throws IOException {
        return englishSpellerRule.getSpellingSuggestions(word);
    }
}

