/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.AttributesToMapConverter;
import org.gradle.api.internal.artifacts.transform.ComponentToOperationConverter;
import org.gradle.api.internal.artifacts.transform.SnapshotTransformInputsBuildOperationResult;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResultSerializer;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.properties.DefaultInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.provider.Provider;
import org.gradle.internal.execution.ExecutionContext;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.ImplementationVisitor;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.OutputVisitor;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkOutput;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.UncategorizedBuildOperations;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.operations.dependencies.transforms.ExecuteTransformActionBuildOperationType;
import org.gradle.operations.dependencies.transforms.IdentifyTransformExecutionProgressDetails;
import org.gradle.operations.dependencies.transforms.SnapshotTransformInputsBuildOperationType;
import org.gradle.work.InputChanges;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransformExecution
implements UnitOfWork {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransformExecution.class);
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final CachingDisabledReason CACHING_DISABLED_REASON = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching disabled by property ('org.gradle.internal.transform-caching-disabled')");
    protected static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    protected static final String INPUT_ARTIFACT_PATH_PROPERTY_NAME = "inputArtifactPath";
    protected static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    protected static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final SnapshotTransformInputsBuildOperationType.Details SNAPSHOT_TRANSFORM_INPUTS_DETAILS = new SnapshotTransformInputsBuildOperationType.Details(){};
    protected final Transform transform;
    protected final File inputArtifact;
    private final TransformDependencies dependencies;
    private final TransformStepSubject subject;
    private final TransformExecutionListener transformExecutionListener;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter progressEventEmitter;
    private final FileCollectionFactory fileCollectionFactory;
    private final Provider<FileSystemLocation> inputArtifactProvider;
    protected final InputFingerprinter inputFingerprinter;
    private final boolean disableCachingByProperty;
    private BuildOperationContext operationContext;

    protected AbstractTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, TransformExecutionListener transformExecutionListener, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, boolean disableCachingByProperty) {
        this.transform = transform;
        this.inputArtifact = inputArtifact;
        this.dependencies = dependencies;
        this.inputArtifactProvider = Providers.of((Object)new DefaultFileSystemLocation(inputArtifact));
        this.subject = subject;
        this.transformExecutionListener = transformExecutionListener;
        this.buildOperationRunner = buildOperationRunner;
        this.progressEventEmitter = progressEventEmitter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.disableCachingByProperty = disableCachingByProperty;
    }

    public Optional<String> getBuildOperationWorkType() {
        return Optional.of("TRANSFORM");
    }

    public Identity identify(Map<String, ValueSnapshot> scalarInputs, Map<String, CurrentFileCollectionFingerprint> fileInputs) {
        TransformWorkspaceIdentity transformWorkspaceIdentity = this.createIdentity(scalarInputs, fileInputs);
        this.emitIdentifyTransformExecutionProgressDetails(transformWorkspaceIdentity);
        return transformWorkspaceIdentity;
    }

    protected abstract TransformWorkspaceIdentity createIdentity(Map<String, ValueSnapshot> var1, Map<String, CurrentFileCollectionFingerprint> var2);

    public WorkOutput execute(ExecutionContext executionContext) {
        this.transformExecutionListener.beforeTransformExecution((Describable)this.transform, (Describable)this.subject);
        try {
            WorkOutput workOutput = this.executeWithinTransformerListener(executionContext);
            return workOutput;
        }
        finally {
            this.transformExecutionListener.afterTransformExecution((Describable)this.transform, (Describable)this.subject);
        }
    }

    private WorkOutput executeWithinTransformerListener(final ExecutionContext executionRequest) {
        final TransformExecutionResult result = (TransformExecutionResult)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<TransformExecutionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TransformExecutionResult call(BuildOperationContext context) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transforming {} with {}", (Object)AbstractTransformExecution.this.subject.getDisplayName(), (Object)AbstractTransformExecution.this.transform.getDisplayName());
                    }
                    File workspace = executionRequest.getWorkspace();
                    InputChangesInternal inputChanges = executionRequest.getInputChanges().orElse(null);
                    TransformExecutionResult result = AbstractTransformExecution.this.transform.transform((Provider<FileSystemLocation>)AbstractTransformExecution.this.inputArtifactProvider, AbstractTransformExecution.getOutputDir(workspace), AbstractTransformExecution.this.dependencies, (InputChanges)inputChanges);
                    TransformExecutionResultSerializer resultSerializer = new TransformExecutionResultSerializer();
                    resultSerializer.writeToFile(AbstractTransformExecution.getResultsFile(workspace), result);
                    TransformExecutionResult transformExecutionResult = result;
                    return transformExecutionResult;
                }
                finally {
                    context.setResult((Object)ExecuteTransformActionBuildOperationType.RESULT_INSTANCE);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = AbstractTransformExecution.this.transform.getDisplayName() + " " + AbstractTransformExecution.this.inputArtifact.getName();
                return BuildOperationDescriptor.displayName((String)displayName).details((Object)ExecuteTransformActionBuildOperationType.DETAILS_INSTANCE).metadata((BuildOperationMetadata)UncategorizedBuildOperations.TRANSFORM_ACTION).progressDisplayName(displayName);
            }
        });
        return new WorkOutput(){

            public WorkOutput.WorkResult getDidWork() {
                return WorkOutput.WorkResult.DID_WORK;
            }

            public Object getOutput(File workspace) {
                return result.resolveForWorkspace(AbstractTransformExecution.getOutputDir(workspace));
            }
        };
    }

    public Object loadAlreadyProducedOutput(File workspace) {
        TransformExecutionResultSerializer resultSerializer = new TransformExecutionResultSerializer();
        return resultSerializer.readResultsFile(AbstractTransformExecution.getResultsFile(workspace)).resolveForWorkspace(AbstractTransformExecution.getOutputDir(workspace));
    }

    public InputFingerprinter getInputFingerprinter() {
        return this.inputFingerprinter;
    }

    private static File getOutputDir(File workspace) {
        return new File(workspace, "transformed");
    }

    private static File getResultsFile(File workspace) {
        return new File(workspace, "results.bin");
    }

    public void visitImplementations(ImplementationVisitor visitor) {
        visitor.visitImplementation(this.transform.getImplementationClass());
    }

    @OverridingMethodsMustInvokeSuper
    public void visitImmutableInputs(InputVisitor visitor) {
        visitor.visitInputProperty(SECONDARY_INPUTS_HASH_PROPERTY_NAME, this.transform::getSecondaryInputHash);
        visitor.visitInputProperty(INPUT_ARTIFACT_PATH_PROPERTY_NAME, () -> this.transform.getInputArtifactNormalizer() == InputNormalizer.ABSOLUTE_PATH ? this.inputArtifact.getAbsolutePath() : this.inputArtifact.getName());
        visitor.visitInputFileProperty(DEPENDENCIES_PROPERTY_NAME, InputBehavior.NON_INCREMENTAL, new InputVisitor.InputFileValueSupplier((Object)this.dependencies, this.transform.getInputArtifactDependenciesNormalizer(), this.transform.getInputArtifactDependenciesDirectorySensitivity(), this.transform.getInputArtifactDependenciesLineEndingNormalization(), () -> this.dependencies.getFiles().orElse((FileCollection)FileCollectionFactory.empty())));
    }

    protected void emitIdentifyTransformExecutionProgressDetails(TransformWorkspaceIdentity transformWorkspaceIdentity) {
        this.progressEventEmitter.emitNowIfCurrent((Object)new DefaultIdentifyTransformExecutionProgressDetails(this.inputArtifact, transformWorkspaceIdentity, this.transform, this.subject.getInitialComponentIdentifier()));
    }

    protected void visitInputArtifact(InputVisitor visitor) {
        visitor.visitInputFileProperty(INPUT_ARTIFACT_PROPERTY_NAME, InputBehavior.INCREMENTAL, new InputVisitor.InputFileValueSupplier(this.inputArtifactProvider, this.transform.getInputArtifactNormalizer(), this.transform.getInputArtifactDirectorySensitivity(), this.transform.getInputArtifactLineEndingNormalization(), () -> this.fileCollectionFactory.fixed(new File[]{this.inputArtifact})));
    }

    public void visitOutputs(File workspace, OutputVisitor visitor) {
        File outputDir = AbstractTransformExecution.getOutputDir(workspace);
        File resultsFile = AbstractTransformExecution.getResultsFile(workspace);
        visitor.visitOutputProperty(OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, OutputVisitor.OutputFileValueSupplier.fromStatic((File)outputDir, (FileCollection)this.fileCollectionFactory.fixed(new File[]{outputDir})));
        visitor.visitOutputProperty(RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, OutputVisitor.OutputFileValueSupplier.fromStatic((File)resultsFile, (FileCollection)this.fileCollectionFactory.fixed(new File[]{resultsFile})));
    }

    public void markLegacySnapshottingInputsStarted() {
        this.operationContext = this.buildOperationRunner.start(BuildOperationDescriptor.displayName((String)"Snapshot transform inputs").name("Snapshot transform inputs").details((Object)SNAPSHOT_TRANSFORM_INPUTS_DETAILS));
    }

    public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
        if (this.operationContext != null) {
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            builder.add((Object)new DefaultInputFilePropertySpec(INPUT_ARTIFACT_PROPERTY_NAME, this.transform.getInputArtifactNormalizer(), FileCollectionFactory.empty(), PropertyValue.ABSENT, InputBehavior.INCREMENTAL, this.transform.getInputArtifactDirectorySensitivity(), this.transform.getInputArtifactLineEndingNormalization()));
            builder.add((Object)new DefaultInputFilePropertySpec(DEPENDENCIES_PROPERTY_NAME, this.transform.getInputArtifactDependenciesNormalizer(), FileCollectionFactory.empty(), PropertyValue.ABSENT, InputBehavior.NON_INCREMENTAL, this.transform.getInputArtifactDependenciesDirectorySensitivity(), this.transform.getInputArtifactDependenciesLineEndingNormalization()));
            this.operationContext.setResult((Object)new SnapshotTransformInputsBuildOperationResult(cachingState, (Set<InputFilePropertySpec>)builder.build()));
            this.operationContext = null;
        }
    }

    public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return this.transform.isCacheable() ? this.maybeDisableCachingByProperty() : Optional.of(NOT_CACHEABLE);
    }

    private Optional<CachingDisabledReason> maybeDisableCachingByProperty() {
        if (this.disableCachingByProperty) {
            return Optional.of(CACHING_DISABLED_REASON);
        }
        return Optional.empty();
    }

    public String getDisplayName() {
        return this.transform.getDisplayName() + ": " + this.inputArtifact;
    }

    private static class DefaultIdentifyTransformExecutionProgressDetails
    implements IdentifyTransformExecutionProgressDetails {
        private final File inputArtifact;
        private final TransformWorkspaceIdentity transformWorkspaceIdentity;
        private final Transform transform;
        private final ComponentIdentifier componentIdentifier;

        public DefaultIdentifyTransformExecutionProgressDetails(File inputArtifact, TransformWorkspaceIdentity transformWorkspaceIdentity, Transform transform, ComponentIdentifier componentIdentifier) {
            this.inputArtifact = inputArtifact;
            this.transformWorkspaceIdentity = transformWorkspaceIdentity;
            this.transform = transform;
            this.componentIdentifier = componentIdentifier;
        }

        public String getIdentity() {
            return this.transformWorkspaceIdentity.getUniqueId();
        }

        public Map<String, String> getFromAttributes() {
            return AttributesToMapConverter.convertToMap((AttributeContainer)this.transform.getFromAttributes());
        }

        public Map<String, String> getToAttributes() {
            return AttributesToMapConverter.convertToMap((AttributeContainer)this.transform.getToAttributes());
        }

        public org.gradle.operations.dependencies.variants.ComponentIdentifier getComponentId() {
            return ComponentToOperationConverter.convertComponentIdentifier(this.componentIdentifier);
        }

        public String getArtifactName() {
            return this.inputArtifact.getName();
        }

        public Class<?> getTransformActionClass() {
            return this.transform.getImplementationClass();
        }

        public byte[] getSecondaryInputValueHashBytes() {
            return Hashing.hashHashable((Hashable)this.transformWorkspaceIdentity.getSecondaryInputsSnapshot()).toByteArray();
        }
    }
}

