﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/AssetBundleExportJobDataSetPropertyToOverride.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>Controls how a specific <code>DataSet</code> resource is parameterized in the
 * returned CloudFormation template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/AssetBundleExportJobDataSetOverrideProperties">AWS
 * API Reference</a></p>
 */
class AssetBundleExportJobDataSetOverrideProperties {
 public:
  AWS_QUICKSIGHT_API AssetBundleExportJobDataSetOverrideProperties() = default;
  AWS_QUICKSIGHT_API AssetBundleExportJobDataSetOverrideProperties(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API AssetBundleExportJobDataSetOverrideProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the specific <code>DataSet</code> resource whose override
   * properties are configured in this structure.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  AssetBundleExportJobDataSetOverrideProperties& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>DataSet</code> resource properties to generate variables for
   * in the returned CloudFormation template.</p>
   */
  inline const Aws::Vector<AssetBundleExportJobDataSetPropertyToOverride>& GetProperties() const { return m_properties; }
  inline bool PropertiesHasBeenSet() const { return m_propertiesHasBeenSet; }
  template <typename PropertiesT = Aws::Vector<AssetBundleExportJobDataSetPropertyToOverride>>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::Vector<AssetBundleExportJobDataSetPropertyToOverride>>
  AssetBundleExportJobDataSetOverrideProperties& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  inline AssetBundleExportJobDataSetOverrideProperties& AddProperties(AssetBundleExportJobDataSetPropertyToOverride value) {
    m_propertiesHasBeenSet = true;
    m_properties.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::Vector<AssetBundleExportJobDataSetPropertyToOverride> m_properties;
  bool m_propertiesHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
